set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8937373';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4030',
      NULL,
      '31413340',
      '01034300',
      '01011333',
      '31321224',
      NULL,
      '03104111',
      '30044422',
      '31423413',
      NULL,
      '33122022',
      '04043441',
      '33112344',
      '01342002',
      NULL,
      '40440334',
      '12003300',
      NULL,
      '44013042',
      '20414324',
      NULL,
      '11324232',
      '22233241',
      '31332211',
      NULL,
      '11000303',
      '01410312',
      '42142421',
      '14031241',
      '40044220',
      '40343031',
      '44223112',
      '43021243',
      '12400130',
      NULL,
      '02002421',
      '20341002',
      '03002344',
      '32420144',
      '41232102',
      '30023012',
      '32440141',
      '14013343',
      '11001222',
      '101',
      '20',
      NULL,
      NULL,
      '4243004',
      3,
      1.457593,
      3,
      NULL,
      NULL,
      5.612332,
      ' 9-19-1999',
      ' 9- 6-1996',
      89,
      NULL,
      46.271546,
      NULL,
      21,
      NULL,
      8,
      8.525397,
      2.863237,
      NULL,
      NULL,
      23,
      31,
      23.132016,
      29,
      12.135569,
      25.685423,
      15.985367,
      3,
      7,
      NULL,
      18.694932,
      33.626378,
      NULL,
      0,
      21,
      43.384745,
      88.724004,
      163.142295,
      105,
      86.364995,
      '11- 6-1985',
      21,
      47.781865,
      NULL,
      21.842651,
      187,
      183.415357,
      ' 4-22-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4- 7-1985',
      NULL,
      86.289760,
      32.080617,
      34.869459,
      34.031744,
      NULL,
      66,
      1,
      105.429286,
      NULL,
      13.411213,
      59,
      ' 5-29-1977',
      26,
      NULL,
      27,
      47.630436,
      NULL,
      147,
      NULL,
      ' 9-18-1978',
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      21.548788,
      27.933052,
      21.468457,
      11,
      0,
      NULL,
      0,
      95,
      1.646326,
      0,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0- 1-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      12.726837,
      28,
      ' 8-19-1977',
      1,
      16,
      ' 0-19-2002',
      8,
      0.515545,
      4.603563,
      8.047480,
      '11-14-1995',
      30,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.248343,
      0,
      5,
      0,
      0,
      91.192838,
      2.438617,
      5.651890,
      106.025615,
      3.873718,
      6.696642,
      97,
      NULL,
      33.484835,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.971743,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      5.093987,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-29-1995',
      '10- 6-1989',
      NULL,
      ' 6- 1-1978',
      NULL,
      NULL,
      NULL);
commit;
end;
/


