set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7641080';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3341',
      '11231343',
      '21333404',
      '41223242',
      '33131402',
      '30301300',
      '24203314',
      '22443120',
      '12303400',
      NULL,
      NULL,
      '42132421',
      '44120203',
      '41420102',
      '40202320',
      '03113443',
      '12033100',
      '14231040',
      '40431221',
      '20113310',
      '33334010',
      '32034203',
      NULL,
      '03333223',
      '24212234',
      '11044441',
      '12003332',
      '41420441',
      '20433440',
      NULL,
      NULL,
      NULL,
      NULL,
      '04212244',
      '12304324',
      NULL,
      '01323220',
      '14202231',
      '20330312',
      '34301222',
      '40421241',
      '33412123',
      '40210412',
      NULL,
      '20132343',
      '203',
      '41',
      NULL,
      NULL,
      '1022122',
      1.452585,
      0.937574,
      NULL,
      NULL,
      '322302',
      5,
      ' 9-11-2003',
      '10- 9-2000',
      51,
      NULL,
      25,
      NULL,
      5,
      24,
      62,
      10.067284,
      25,
      NULL,
      25,
      2.947043,
      NULL,
      NULL,
      3,
      1,
      13.065097,
      22.621199,
      0.635235,
      24.390519,
      83.101231,
      32.885723,
      130,
      11.277708,
      1,
      NULL,
      37.792744,
      61,
      15.132323,
      186,
      186,
      ' 1-25-1995',
      63.066476,
      34,
      29,
      9.585149,
      31,
      135,
      ' 1-21-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      48,
      8.477313,
      5.101040,
      9.379028,
      9.694524,
      7.672969,
      ' 1-25-1979',
      1,
      NULL,
      176,
      0,
      NULL,
      105.408312,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-17-1999',
      69.633499,
      89.399097,
      NULL,
      9.413260,
      18.291244,
      29,
      NULL,
      32.941446,
      11,
      NULL,
      59.245904,
      8.015052,
      ' 8-24-1976',
      7.039035,
      25.721745,
      15,
      5.173070,
      39.217397,
      61.842842,
      0.466529,
      '10- 2-1977',
      NULL,
      4,
      NULL,
      8.654095,
      10,
      20,
      6.350810,
      NULL,
      NULL,
      1.108766,
      5,
      1,
      30,
      0.416662,
      1.620283,
      0,
      NULL,
      0.101162,
      NULL,
      NULL,
      1.007037,
      ' 3- 4-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      101,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      30.941300,
      ' 0-27-1994',
      NULL,
      ' 0-25-1990',
      1,
      15.727710,
      ' 8- 1-1989',
      51.833597,
      68,
      ' 9-20-1977',
      5,
      1,
      ' 0-20-1977',
      NULL,
      NULL,
      NULL,
      0,
      2,
      13.235359,
      NULL,
      15,
      17,
      NULL,
      ' 7-17-1992',
      0.388009,
      65.165107,
      NULL,
      12.868418,
      9.189533,
      6.769919,
      18,
      ' 4-20-1984',
      18.926983,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


