set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9019289';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      '14302200',
      '11320123',
      '43011342',
      '14002042',
      '34131404',
      '40244010',
      '12430340',
      '03223102',
      NULL,
      NULL,
      '42230323',
      '30431043',
      '10024240',
      '23431344',
      '44321041',
      NULL,
      '00314442',
      '02443322',
      '40402210',
      NULL,
      '31221120',
      '41112121',
      NULL,
      '13300123',
      NULL,
      '12401212',
      NULL,
      '14300230',
      NULL,
      '40234212',
      '13231410',
      '23332241',
      '22401211',
      NULL,
      NULL,
      '31043304',
      '42120230',
      '14234024',
      '30222244',
      '11021434',
      '02342200',
      '',
      '',
      NULL,
      NULL,
      NULL,
      0,
      1,
      2,
      NULL,
      '410131',
      1.653722,
      ' 3- 7-1993',
      ' 4-20-1998',
      14.634782,
      NULL,
      NULL,
      NULL,
      21.401179,
      14,
      NULL,
      30,
      25.813806,
      35.603285,
      26,
      0,
      NULL,
      7.315267,
      25,
      5,
      22,
      2,
      51.017583,
      NULL,
      71,
      NULL,
      34,
      11,
      NULL,
      103.094660,
      246.483069,
      83,
      60,
      251.172173,
      210,
      NULL,
      0.455946,
      15.507679,
      21,
      17,
      2.251392,
      116.826993,
      ' 1-27-1989',
      NULL,
      1,
      1.168731,
      1.835256,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.555793,
      2.086194,
      1,
      0,
      0.403053,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8- 2-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7- 1-1987',
      60,
      117.153074,
      97,
      124,
      141,
      46.373229,
      NULL,
      120,
      NULL,
      91.713202,
      42,
      NULL,
      '11-12-2000',
      19,
      16.356108,
      31,
      30,
      11.496771,
      12.506528,
      3,
      ' 4-26-1995',
      25,
      22,
      ' 9- 1-1977',
      11,
      6.442674,
      17.003322,
      20.255822,
      1.355011,
      4.279401,
      NULL,
      15.181420,
      NULL,
      126.968136,
      3,
      NULL,
      21,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6- 5-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      39,
      NULL,
      NULL,
      ' 8-10-1980',
      1.642623,
      58.433567,
      ' 6-19-1993',
      15.956013,
      30.230264,
      NULL,
      11.703434,
      ' 4- 3-1985',
      NULL,
      1.062210,
      118.107343,
      ' 6- 8-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      107.669083,
      16,
      2.619427,
      17.675291,
      3,
      11.030075,
      NULL,
      1.328830,
      1,
      NULL,
      0.666909,
      NULL,
      29.223971,
      1.524352,
      0,
      62.980614,
      0,
      0.335666,
      104.255372,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      0.805079,
      1.702474,
      0,
      1,
      1.846460,
      0,
      NULL,
      NULL,
      NULL,
      16.317040,
      NULL,
      NULL,
      NULL,
      NULL,
      44,
      NULL,
      2,
      14.040920,
      3.339815,
      0,
      NULL,
      NULL,
      NULL,
      0.560767,
      0,
      NULL,
      34.343408,
      1,
      17,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0.052392,
      1.003650,
      1,
      0,
      NULL,
      0.774733,
      NULL,
      ' 3-16-1992',
      ' 3- 0-1988',
      ' 0-23-1977',
      ' 0-17-1974',
      ' 0- 1-1984',
      ' 9-28-1981',
      ' 2- 9-1987',
      NULL);
commit;
end;
/


