set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8910326';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1204',
      '41200021',
      NULL,
      '14303110',
      '32222201',
      '14214143',
      '04040244',
      '23414342',
      '34132304',
      '04031113',
      '32330021',
      '00303133',
      NULL,
      '22333134',
      '40210021',
      '10100413',
      '12342413',
      NULL,
      '04200043',
      '03123302',
      '14343322',
      '44014430',
      '23204421',
      '12131131',
      NULL,
      '31110041',
      NULL,
      NULL,
      '44021413',
      '34124313',
      '12412042',
      '32023343',
      '02114312',
      '01112331',
      '40234412',
      '32342340',
      NULL,
      '30120222',
      '23433042',
      NULL,
      '21420201',
      '01421311',
      '21442024',
      '02020300',
      '03244021',
      '',
      '',
      NULL,
      NULL,
      '2041432',
      NULL,
      1,
      2,
      NULL,
      '034134',
      2,
      ' 2-20-1992',
      ' 5-12-1993',
      NULL,
      NULL,
      27.591109,
      21,
      14.032935,
      NULL,
      35,
      15.591294,
      5.687424,
      8,
      29,
      9.954787,
      NULL,
      18.948752,
      NULL,
      23.457912,
      37.983001,
      NULL,
      36.471658,
      3,
      48.356475,
      13,
      131,
      NULL,
      NULL,
      5.992905,
      26.033144,
      43.849324,
      125,
      297.554731,
      198,
      ' 7-12-1996',
      43,
      NULL,
      NULL,
      19.660500,
      NULL,
      140.067746,
      ' 3-24-2001',
      0.899841,
      3.595943,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4- 7-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-22-1980',
      45.966165,
      55,
      NULL,
      35,
      100.000087,
      4,
      68.355890,
      97,
      33.455452,
      108,
      113,
      75,
      ' 6- 5-2000',
      15,
      24,
      26.938179,
      112,
      101,
      64.801589,
      NULL,
      NULL,
      8,
      10.758339,
      ' 0-19-1985',
      NULL,
      16.649763,
      NULL,
      12,
      21,
      12.210597,
      NULL,
      NULL,
      NULL,
      133.164891,
      0.800240,
      3,
      22.821735,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-10-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      20,
      NULL,
      NULL,
      '10-15-1989',
      0.738035,
      42.418926,
      ' 9- 3-1994',
      NULL,
      35,
      NULL,
      NULL,
      ' 3-17-1989',
      68.017307,
      1,
      0.991824,
      '11- 6-1978',
      NULL,
      NULL,
      NULL,
      135,
      NULL,
      54.567433,
      26,
      37.079590,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      59.270334,
      1,
      1.819835,
      2,
      1,
      1.275423,
      8.536536,
      NULL,
      0,
      46,
      NULL,
      13,
      170.100064,
      NULL,
      134.131698,
      1,
      1.306959,
      0,
      0,
      1,
      0,
      169.090470,
      54,
      65,
      NULL,
      82.987104,
      156,
      0,
      NULL,
      21.217245,
      0.994285,
      0,
      0,
      22.801996,
      0,
      0.015742,
      2.008124,
      157,
      0.646055,
      0.198977,
      42.962620,
      13.907237,
      18,
      17.940085,
      95.590202,
      47,
      NULL,
      166,
      18,
      NULL,
      1.103488,
      NULL,
      1.816087,
      0,
      1,
      1.390257,
      59,
      NULL,
      NULL,
      ' 2-17-1979',
      '10-28-1991',
      '10-28-1980',
      ' 9-10-1976',
      NULL,
      NULL);
commit;
end;
/


