set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8423044';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '30303024',
      '13141001',
      '12311343',
      '11322432',
      '01334141',
      '14240240',
      NULL,
      NULL,
      '31111003',
      NULL,
      NULL,
      '32242101',
      '20424022',
      '02441322',
      '20444000',
      '22212121',
      NULL,
      '41131033',
      '44044432',
      '20210323',
      '11044301',
      NULL,
      '41042322',
      '30034321',
      NULL,
      NULL,
      '22142304',
      '33110142',
      '24330301',
      '24321244',
      NULL,
      '13301331',
      '14021240',
      NULL,
      '40131443',
      '04403112',
      '14224413',
      '21414223',
      '42101012',
      NULL,
      NULL,
      '02244032',
      '10221221',
      '34220134',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.077022,
      3,
      NULL,
      '324242',
      0,
      ' 2- 7-1986',
      ' 9- 8-1983',
      60.528518,
      NULL,
      8.833274,
      11,
      13,
      14,
      79.222164,
      NULL,
      14.093546,
      13,
      6.350588,
      NULL,
      23,
      0,
      11.408630,
      NULL,
      5.673457,
      9.952999,
      9,
      1,
      60.498123,
      3.736978,
      95.564835,
      11.715613,
      NULL,
      NULL,
      7.155400,
      NULL,
      141.921551,
      NULL,
      59,
      '10-25-1988',
      11.510760,
      52,
      NULL,
      18.954675,
      153.343833,
      0.104480,
      ' 0-10-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-26-1993',
      53,
      55,
      31,
      4,
      NULL,
      19,
      52.885095,
      69,
      92,
      67.552443,
      103,
      62.733716,
      NULL,
      21.136157,
      8.411781,
      5.742737,
      57,
      10,
      26,
      6.614551,
      ' 1-18-1980',
      NULL,
      9,
      ' 9- 7-2003',
      11.711529,
      20.457402,
      16.873220,
      20,
      9,
      10,
      NULL,
      8,
      NULL,
      20,
      NULL,
      1,
      23,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      17,
      4,
      4,
      NULL,
      0,
      57.546424,
      ' 6-18-1995',
      NULL,
      1,
      19.041401,
      24,
      ' 1-16-1985',
      NULL,
      NULL,
      49.419229,
      NULL,
      NULL,
      NULL,
      NULL,
      34.963041,
      NULL,
      NULL,
      NULL,
      54,
      137.608766,
      59.106611,
      0,
      24.016905,
      0.195973,
      11.585041,
      6.439769,
      4,
      0,
      114,
      10.849326,
      1.170839,
      NULL,
      1.984279,
      0,
      NULL,
      16.026139,
      1.424029,
      18,
      1,
      16.998524,
      18,
      0,
      NULL,
      4.125381,
      1,
      1,
      1,
      1.534281,
      1.377342,
      61.691024,
      30,
      1,
      24.436875,
      59.595368,
      18.782770,
      NULL,
      1,
      22,
      0.583717,
      0.964984,
      1.291840,
      53.552283,
      NULL,
      54,
      0,
      36.411608,
      0.443461,
      1.173145,
      11.898364,
      NULL,
      NULL,
      20,
      36,
      67.848511,
      11.115909,
      56,
      0,
      NULL,
      1,
      4,
      NULL,
      2,
      1,
      3,
      18,
      ' 3-20-1980',
      ' 3- 3-1995',
      NULL,
      NULL,
      ' 7-15-1988',
      NULL,
      NULL,
      NULL);
commit;
end;
/


