set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '3284800';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '0',
      NULL,
      '2',
      '1',
      '0',
      '3',
      '0',
      '1',
      NULL,
      '2',
      '0',
      '4',
      '3',
      '3',
      '4',
      '3',
      '1',
      '1',
      NULL,
      '1',
      '2',
      NULL,
      '3',
      '',
      '2',
      '',
      '4',
      NULL,
      '4',
      '4',
      '3',
      '',
      '',
      NULL,
      '3',
      '0',
      '1',
      '0',
      '0',
      '3',
      '1',
      '1',
      '0',
      '1',
      '003',
      '40211003',
      44.395080,
      56.085208,
      '1311033',
      1,
      NULL,
      2,
      0,
      '102042',
      3.640441,
      NULL,
      NULL,
      111.161674,
      NULL,
      NULL,
      25.284368,
      NULL,
      NULL,
      113,
      7,
      0.934321,
      4,
      14.119741,
      NULL,
      13,
      18,
      7.413634,
      5.222543,
      31,
      14.643688,
      8,
      35,
      NULL,
      30,
      147,
      NULL,
      1,
      76.860872,
      213.802011,
      83,
      98,
      240,
      132.541929,
      ' 7- 0-2000',
      25.577871,
      NULL,
      2.725582,
      2.954869,
      100,
      41,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      84,
      2,
      NULL,
      7,
      0,
      1,
      ' 7- 1-1994',
      1,
      NULL,
      117.026615,
      1,
      1,
      NULL,
      1,
      0.734307,
      66.345289,
      NULL,
      NULL,
      NULL,
      ' 3-27-1976',
      101.720150,
      50,
      108,
      NULL,
      NULL,
      5.632550,
      46.147305,
      71.058288,
      65.484291,
      43,
      25.983989,
      17,
      ' 2-21-1980',
      20.307240,
      22,
      11.254901,
      62.003055,
      70.528341,
      65,
      6,
      ' 1-29-1981',
      19.051024,
      6.351901,
      NULL,
      1.900935,
      NULL,
      NULL,
      11.709272,
      26,
      NULL,
      1,
      20.610192,
      0.898555,
      NULL,
      4,
      1,
      1.165107,
      NULL,
      NULL,
      1.202417,
      0.910487,
      1.814276,
      ' 1-29-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      78.193971,
      3.644505,
      ' 3-23-1976',
      NULL,
      NULL,
      NULL,
      44.743918,
      ' 0- 6-2001',
      4,
      ' 8-29-1993',
      17,
      17.431731,
      ' 3-28-1995',
      14,
      15.293947,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      23,
      NULL,
      44,
      8.253133,
      7.543125,
      ' 1-14-1998',
      0.969480,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


