set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '5613373';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1344',
      '30212141',
      '41321301',
      '04340230',
      '21213424',
      '04021033',
      '44413234',
      '44421032',
      '04301243',
      '43443140',
      '13423440',
      '12120410',
      '43403022',
      '23032012',
      '40302133',
      '24143443',
      '33244442',
      '02240002',
      '43311314',
      '21433140',
      '43243311',
      NULL,
      '41230320',
      NULL,
      NULL,
      '40420422',
      '13144022',
      NULL,
      '00330320',
      '03034120',
      NULL,
      '43144030',
      '44332011',
      '43021102',
      '30414122',
      '44004124',
      '21223133',
      '31141014',
      NULL,
      NULL,
      NULL,
      '03322142',
      '34320144',
      '30130214',
      NULL,
      '310',
      '23',
      NULL,
      NULL,
      '0243304',
      NULL,
      0.172728,
      0,
      NULL,
      '234303',
      NULL,
      ' 3-25-1981',
      ' 4- 7-1980',
      13,
      NULL,
      NULL,
      9.412416,
      22.159880,
      5.346427,
      33.138141,
      18.430005,
      NULL,
      25.387774,
      16,
      NULL,
      26.130710,
      NULL,
      25.147649,
      19.119210,
      NULL,
      2,
      21,
      NULL,
      26.040150,
      NULL,
      74,
      2.199342,
      NULL,
      NULL,
      188,
      85,
      194.448126,
      167.370631,
      24.104833,
      '10-17-1998',
      49.067278,
      13,
      NULL,
      12,
      34,
      81.727139,
      NULL,
      7.558203,
      8.760562,
      1.788426,
      2.978235,
      13,
      7,
      NULL,
      3.779101,
      1,
      0,
      8.704775,
      2,
      2.719278,
      3,
      3.431168,
      0.926829,
      0,
      0,
      1,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      44.428982,
      NULL,
      5.599125,
      NULL,
      7,
      4.257944,
      ' 0-13-2003',
      5,
      1,
      125,
      0.065257,
      NULL,
      71,
      0,
      0.645316,
      8.736574,
      3.356856,
      0.106325,
      NULL,
      ' 3- 7-1976',
      69.416851,
      3.120399,
      3.623545,
      67.086828,
      55,
      NULL,
      89.590412,
      65,
      108.136316,
      49,
      NULL,
      NULL,
      ' 9- 9-1977',
      7.359994,
      3.049218,
      14,
      NULL,
      21.719989,
      3.933859,
      2.350443,
      ' 5-19-1991',
      NULL,
      NULL,
      NULL,
      1.421788,
      11,
      14.201994,
      13,
      7.225361,
      NULL,
      1.197473,
      NULL,
      1,
      18.386450,
      NULL,
      0.001401,
      4,
      2,
      NULL,
      0,
      0,
      0,
      NULL,
      3.328117,
      2,
      0.157280,
      NULL,
      43,
      6.682000,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-15-1992',
      38,
      NULL,
      NULL,
      1.708853,
      ' 2-14-1993',
      NULL,
      95.813867,
      ' 2- 8-2003',
      0.967948,
      1,
      ' 3-25-1985',
      0.519425,
      18.581041,
      ' 6- 0-2003',
      2,
      2,
      14.656812,
      NULL,
      29,
      NULL,
      NULL,
      '11-20-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.324062);
commit;
end;
/


