set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9819270';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      NULL,
      '3',
      NULL,
      '4',
      '4',
      '4',
      '1',
      NULL,
      '2',
      '3',
      NULL,
      '3',
      NULL,
      '2',
      '3',
      '4',
      '3',
      '1',
      NULL,
      '0',
      '1',
      '2',
      '1',
      NULL,
      '1',
      '',
      NULL,
      NULL,
      NULL,
      '1',
      '3',
      '',
      NULL,
      '4',
      '1',
      '4',
      '3',
      NULL,
      NULL,
      '3',
      '3',
      '4',
      '3',
      '1',
      '023',
      NULL,
      16.201358,
      66,
      NULL,
      0.208795,
      1.869394,
      NULL,
      NULL,
      '241413',
      5.971289,
      NULL,
      ' 6- 7-1992',
      200,
      71.400369,
      1.051512,
      7.274263,
      NULL,
      20.020205,
      NULL,
      5.841146,
      NULL,
      NULL,
      10,
      9,
      4,
      10.668861,
      9,
      NULL,
      12,
      16.626468,
      6.169186,
      9,
      36,
      23.607961,
      NULL,
      2.844575,
      0,
      106,
      NULL,
      17.952780,
      124,
      42.629089,
      NULL,
      ' 5-27-2001',
      NULL,
      17,
      NULL,
      33,
      123.861607,
      25,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      107,
      13.302411,
      8,
      13.536275,
      10.911325,
      6,
      ' 5- 0-1983',
      NULL,
      0,
      163,
      1.928049,
      1.421393,
      NULL,
      NULL,
      3,
      86.593613,
      NULL,
      NULL,
      NULL,
      ' 0-22-2002',
      45,
      31.273955,
      11.290052,
      30.529049,
      41,
      13,
      43,
      24,
      25.396358,
      38.179516,
      14.791237,
      61.478606,
      ' 8- 0-1981',
      NULL,
      0.630518,
      14,
      48.327645,
      NULL,
      77.425390,
      11.315715,
      '11-16-1984',
      10,
      11.905084,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      58,
      7,
      ' 6- 3-1996',
      NULL,
      NULL,
      NULL,
      45.140594,
      NULL,
      1,
      ' 4-12-1999',
      15.333553,
      NULL,
      ' 5- 2-2003',
      105,
      NULL,
      ' 4-19-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      ' 7-15-2000',
      5.482949,
      10.013162,
      NULL,
      ' 9- 8-1987',
      1.275050,
      9.214554,
      ' 8-27-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


