set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9915007';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '1',
      '0',
      '4',
      '0',
      '2',
      '2',
      '2',
      NULL,
      '4',
      '2',
      '3',
      '0',
      '0',
      NULL,
      NULL,
      NULL,
      '2',
      '0',
      '2',
      '3',
      '0',
      '4',
      '1',
      '',
      '2',
      '',
      '3',
      '3',
      NULL,
      '0',
      '2',
      '',
      NULL,
      '2',
      NULL,
      '0',
      '4',
      '0',
      '1',
      '2',
      '3',
      '4',
      '4',
      NULL,
      NULL,
      '13012134',
      62.622954,
      10.105744,
      '2004014',
      0,
      1.572317,
      2,
      1,
      '341001',
      NULL,
      ' 6-12-2002',
      ' 6- 0-1981',
      89.130102,
      NULL,
      NULL,
      6.107614,
      0,
      4.086738,
      5.908968,
      2.867105,
      6,
      0.301491,
      5.639047,
      2.168982,
      3,
      0.161294,
      NULL,
      5,
      2.046748,
      1,
      54,
      13,
      43,
      5.988546,
      26,
      2,
      0.840338,
      NULL,
      30.914856,
      21,
      115,
      81.459369,
      69.253875,
      ' 3- 9-1981',
      NULL,
      16.397753,
      NULL,
      3.914284,
      34.577892,
      157.618952,
      ' 4-11-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.257004,
      7,
      NULL,
      4.352589,
      6.901151,
      2.419937,
      ' 2-27-1988',
      NULL,
      NULL,
      1.918278,
      0.798386,
      1.887369,
      19,
      1.565488,
      1.852044,
      9,
      NULL,
      NULL,
      NULL,
      ' 4- 1-1989',
      8.898901,
      23,
      NULL,
      NULL,
      47.621283,
      NULL,
      37.447610,
      NULL,
      NULL,
      39.385136,
      1.004329,
      54.361172,
      ' 7-16-1982',
      NULL,
      5.262121,
      2,
      1,
      16,
      0.807459,
      3,
      '10-20-1976',
      7,
      1.218689,
      ' 5-23-2001',
      4,
      1,
      0.250460,
      3,
      NULL,
      0.336644,
      1.251081,
      1.709318,
      0,
      NULL,
      0,
      1,
      0,
      14.548839,
      2.963798,
      6.324120,
      NULL,
      1.471394,
      ' 9- 1-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      48,
      0,
      ' 1-17-1988',
      NULL,
      NULL,
      NULL,
      27.953845,
      ' 4-20-1978',
      22.755857,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      12.903752,
      ' 0-29-1986',
      9.830754,
      0.200953,
      9,
      NULL,
      1,
      51,
      '10-29-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


