set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9712044';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3224',
      '03413032',
      '14304010',
      '01143401',
      '20030442',
      NULL,
      NULL,
      '31100333',
      '41341342',
      '30201230',
      '01044042',
      NULL,
      '00112131',
      '23140132',
      '42214434',
      NULL,
      '03434311',
      '31134030',
      '32321410',
      '43034232',
      '20030004',
      '33003014',
      '02221344',
      NULL,
      '13012314',
      '43244330',
      '12323310',
      '21113141',
      '40213222',
      '13301334',
      '41423033',
      NULL,
      '01421130',
      NULL,
      '41311114',
      '03412030',
      '30121101',
      '04213004',
      '03114310',
      NULL,
      '30034401',
      '04020212',
      '34244110',
      '41022342',
      '32201133',
      NULL,
      '01',
      33.117295,
      13.619372,
      NULL,
      1.093446,
      NULL,
      1,
      NULL,
      '241043',
      NULL,
      '10-13-1974',
      ' 3- 5-1977',
      97,
      45,
      8,
      6,
      4,
      2,
      NULL,
      NULL,
      28.051828,
      21,
      NULL,
      15,
      3,
      NULL,
      1.287811,
      9,
      12.664958,
      6,
      60,
      NULL,
      52,
      3.762765,
      74,
      8.308984,
      NULL,
      79.196679,
      114,
      88,
      NULL,
      71.854984,
      30.942822,
      ' 8- 1-1999',
      7.295694,
      47,
      20,
      17.635433,
      66,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      29.615975,
      NULL,
      22,
      15.999567,
      NULL,
      ' 9-22-2000',
      0.904737,
      1,
      228,
      0,
      1.582756,
      51,
      0.771814,
      NULL,
      42.096258,
      NULL,
      NULL,
      NULL,
      ' 9-25-2000',
      22.195233,
      NULL,
      24.424107,
      65.900841,
      10,
      19,
      85.146095,
      73,
      56.195043,
      NULL,
      NULL,
      27,
      ' 3- 8-2003',
      9,
      1,
      2.318773,
      1,
      3.781856,
      29.144017,
      7.885647,
      ' 1- 8-1993',
      3.263162,
      5.167560,
      ' 0- 3-1978',
      0,
      11.557294,
      3,
      7.324625,
      10,
      4.111778,
      0,
      NULL,
      0.132662,
      33,
      0.316593,
      0,
      7.775315,
      1.686047,
      1.432564,
      NULL,
      1.269408,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      22,
      2.945511,
      '11-24-1981',
      NULL,
      NULL,
      NULL,
      39.589131,
      ' 7-12-1988',
      44,
      ' 2-21-1990',
      11.776529,
      NULL,
      ' 0- 0-1997',
      57,
      85.092515,
      ' 3- 5-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      ' 2-25-1993',
      13.888869,
      38.344474,
      9.382540,
      '11-22-2003',
      0,
      58.487617,
      ' 9- 5-1990',
      1.702331,
      NULL,
      4.300707,
      33,
      ' 9- 0-1992',
      3,
      0,
      190,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


