set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9231976';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '20014340',
      '30404413',
      '24321321',
      '44241440',
      NULL,
      '42314330',
      '41211443',
      '44123014',
      '01114004',
      '42022330',
      '13403234',
      '03101403',
      '12043013',
      '31422112',
      '21403012',
      '02232224',
      '31212142',
      NULL,
      '10203432',
      '33212104',
      '04120441',
      '23030043',
      '33022334',
      '42030022',
      '30221001',
      '31101342',
      '30233430',
      NULL,
      NULL,
      '30220042',
      NULL,
      '31404002',
      NULL,
      '34441400',
      NULL,
      '10020214',
      '20432021',
      '34414422',
      '32212131',
      '12121214',
      '44403404',
      NULL,
      '22111200',
      '40044320',
      '343',
      '42',
      NULL,
      NULL,
      '1422040',
      1,
      0.568344,
      1,
      NULL,
      '243341',
      0,
      ' 8-12-1996',
      NULL,
      40.073512,
      NULL,
      NULL,
      NULL,
      29.261702,
      15.129694,
      27,
      3,
      15,
      10,
      29.439772,
      4.627391,
      16,
      NULL,
      2.950037,
      1,
      5.377980,
      9.747007,
      NULL,
      11,
      3.582993,
      10.367818,
      101,
      18.319835,
      1,
      NULL,
      105,
      81.538677,
      NULL,
      112.845775,
      158.649560,
      NULL,
      14.649423,
      1.770395,
      19.423469,
      8.935263,
      44,
      62,
      ' 2- 2-1988',
      NULL,
      1,
      10,
      1.153684,
      15,
      3,
      5,
      2.288188,
      0,
      1.282017,
      4,
      1.224292,
      1,
      NULL,
      NULL,
      1,
      4.148120,
      NULL,
      0.259832,
      1.611811,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-10-1980',
      31,
      NULL,
      19,
      6,
      20.103116,
      4.184167,
      '10- 9-1997',
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      36.300035,
      0,
      1,
      62,
      5.914329,
      1.945935,
      134,
      ' 4-26-1979',
      27,
      0,
      67.138872,
      21.065954,
      7.056407,
      NULL,
      NULL,
      68,
      NULL,
      12.686487,
      19,
      47,
      ' 6- 6-1994',
      30.692282,
      13.081967,
      3,
      63.732768,
      NULL,
      78,
      13,
      ' 6- 4-1974',
      NULL,
      NULL,
      ' 5-16-2001',
      NULL,
      12.720497,
      13,
      3,
      11,
      7,
      2.055401,
      2,
      1,
      81.866483,
      6,
      14,
      NULL,
      7,
      3,
      2.231562,
      3,
      1.257113,
      ' 2- 1-1981',
      3,
      2,
      4,
      ' 2-28-1994',
      41,
      10.869252,
      ' 9-14-1999',
      NULL,
      NULL,
      NULL,
      4,
      ' 3- 9-1989',
      13.794060,
      NULL,
      11,
      16,
      '11-28-2002',
      100.619191,
      NULL,
      ' 9-18-1985',
      1,
      1.671965,
      ' 7- 5-1980',
      0,
      5,
      ' 1- 9-1978',
      3,
      1,
      9,
      ' 7-25-2001',
      6.647471,
      0.941693,
      26,
      ' 1- 9-1986',
      0.562434,
      NULL,
      ' 4-27-1995',
      NULL,
      26.532516,
      6,
      57,
      ' 3-13-2002',
      12,
      0,
      69,
      ' 5- 3-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4);
commit;
end;
/


