set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7814692';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4122',
      '01321103',
      '10221021',
      NULL,
      '24312042',
      '23031320',
      '03313343',
      '34443204',
      '41141142',
      '43233113',
      '44024230',
      '31021234',
      '10100031',
      '23404200',
      '02123300',
      '04314102',
      NULL,
      NULL,
      '43444312',
      '21323032',
      '31421000',
      '40304442',
      '23343103',
      '42113140',
      '23223302',
      '23041042',
      '13420141',
      NULL,
      '21021002',
      '22430231',
      '11333231',
      NULL,
      '12132310',
      '24434242',
      '43002414',
      '24301333',
      '12404411',
      '04222433',
      NULL,
      '33022432',
      '23012343',
      '41210230',
      NULL,
      '01012134',
      '33133444',
      NULL,
      '',
      NULL,
      NULL,
      '3340403',
      3.477918,
      0,
      0,
      NULL,
      '033042',
      2.013583,
      ' 8-16-1997',
      NULL,
      6.559340,
      NULL,
      15.062184,
      18.784045,
      22.943245,
      16,
      10.760188,
      22,
      NULL,
      2,
      24.843458,
      NULL,
      NULL,
      0,
      2.984182,
      18.571889,
      13.543024,
      19.349672,
      26,
      9,
      10.819652,
      5,
      46,
      11.847695,
      NULL,
      50,
      18,
      NULL,
      NULL,
      133.731550,
      132.814402,
      ' 0-23-1978',
      64,
      NULL,
      27,
      24,
      158.150357,
      111,
      ' 3-23-1978',
      NULL,
      1,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.574288,
      3,
      1,
      1,
      1.287018,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-18-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2- 7-1974',
      87.641622,
      95.151947,
      71.627910,
      NULL,
      58.644733,
      126,
      112,
      52,
      21.370636,
      47.673724,
      NULL,
      0,
      ' 4-26-2001',
      18,
      19,
      23,
      59.518408,
      NULL,
      37,
      13,
      ' 0- 7-1978',
      NULL,
      14.322307,
      ' 9-13-1981',
      8,
      19.046195,
      2.590968,
      13.905388,
      17,
      NULL,
      NULL,
      NULL,
      NULL,
      97,
      0.019172,
      0.543585,
      5.268976,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-16-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.153875,
      NULL,
      3.151706,
      ' 6-12-1978',
      0,
      76.983701,
      ' 5-24-1984',
      19.260252,
      27.963024,
      12.732710,
      35.761882,
      ' 4-17-1999',
      15.990942,
      0.921197,
      81.569253,
      ' 3-23-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      34,
      0,
      NULL,
      NULL,
      70,
      29.538556,
      13.865059,
      NULL,
      14,
      12.356334,
      NULL,
      1,
      NULL,
      43,
      0.197006,
      NULL,
      NULL,
      0.261061,
      2,
      22.976981,
      1.793470,
      5.111065,
      124,
      NULL,
      30.791846,
      NULL,
      1,
      NULL,
      0.812471,
      1,
      NULL,
      2.179319,
      0,
      0.351713,
      NULL,
      NULL,
      NULL,
      16.145104,
      NULL,
      NULL,
      0.095767,
      1.371370,
      55.794889,
      1.493818,
      7.950929,
      NULL,
      37.399566,
      1,
      NULL,
      0.539550,
      NULL,
      0,
      3.524098,
      NULL,
      2.671827,
      2,
      2,
      NULL,
      NULL,
      1,
      NULL,
      1.639123,
      3,
      1,
      8,
      3.723860,
      1,
      NULL,
      1.046821,
      NULL,
      NULL,
      NULL,
      ' 4-12-1996',
      NULL,
      ' 5-24-2000',
      ' 5-20-1976',
      '11-18-1975',
      NULL);
commit;
end;
/


