set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6905583';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3334',
      NULL,
      NULL,
      '30411010',
      '20400041',
      NULL,
      NULL,
      '20132023',
      '31230244',
      NULL,
      '34402424',
      '31400130',
      '30124413',
      '03011134',
      NULL,
      '10123400',
      '31420334',
      NULL,
      '32304431',
      '04332430',
      NULL,
      NULL,
      '40432303',
      '01232130',
      '10434202',
      '10233021',
      '14143200',
      '31012241',
      NULL,
      '00042131',
      NULL,
      NULL,
      '34333434',
      NULL,
      '41214322',
      '23434444',
      '44303200',
      NULL,
      '21214022',
      '30311213',
      '03243211',
      NULL,
      '20200033',
      '43220301',
      '34123430',
      '421',
      NULL,
      NULL,
      NULL,
      NULL,
      3.026488,
      1,
      0,
      NULL,
      '111132',
      5,
      ' 8-15-1974',
      NULL,
      NULL,
      NULL,
      9.029719,
      8.102990,
      16.722258,
      12.719333,
      7,
      17,
      9,
      10,
      14,
      2.118749,
      37,
      NULL,
      19,
      21.641527,
      NULL,
      NULL,
      4.032373,
      0.647380,
      3.469540,
      9.862250,
      59.771369,
      10,
      0,
      11.686981,
      15,
      87,
      NULL,
      178.845187,
      135.026771,
      ' 8-21-1974',
      NULL,
      NULL,
      10,
      34.062351,
      139.811541,
      109.483268,
      ' 5-21-1989',
      5.416344,
      0,
      9.118101,
      0.358585,
      7.861612,
      1,
      7,
      0,
      0.482750,
      1,
      1,
      1,
      1.364770,
      1,
      0.127636,
      NULL,
      1,
      0.920878,
      0.832622,
      1.715651,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-11-1979',
      58.681199,
      9,
      NULL,
      NULL,
      2,
      8,
      ' 9- 1-1992',
      0,
      2.350557,
      57,
      0,
      0,
      26.194434,
      1,
      1.805287,
      76,
      1.760842,
      1,
      114,
      '11- 2-1995',
      34,
      31.026939,
      13.130631,
      21.158843,
      5,
      31,
      58.454342,
      NULL,
      19,
      48.983246,
      7,
      11,
      ' 9-11-1988',
      10.116944,
      5.456950,
      18.176710,
      12.733526,
      39.328315,
      15,
      3,
      ' 0-19-1999',
      10,
      5,
      NULL,
      8,
      9,
      11,
      3,
      23.172886,
      13,
      NULL,
      1,
      1,
      85.319636,
      6,
      2,
      NULL,
      21.439054,
      3,
      NULL,
      NULL,
      2.471313,
      ' 6-12-1979',
      1,
      0.871246,
      2.575558,
      ' 6-26-2000',
      75,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      45.080221,
      NULL,
      21.909446,
      ' 1-17-1998',
      1,
      17.431211,
      '10-20-1985',
      57.426530,
      34.314262,
      ' 5- 5-1999',
      2,
      6.596681,
      ' 2-29-1993',
      1,
      0,
      ' 6-25-1982',
      NULL,
      0,
      10,
      '10- 1-1988',
      20.537800,
      11,
      46.995666,
      ' 0-19-2002',
      1,
      85,
      ' 7-17-2003',
      7.255797,
      76.704064,
      23,
      NULL,
      ' 6-27-1999',
      5.269269,
      NULL,
      184.669834,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0);
commit;
end;
/


