set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6905583';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2422',
      '42340244',
      NULL,
      '34114430',
      '34430312',
      '34201043',
      '12222411',
      '33042000',
      '31400023',
      '44430434',
      '30302401',
      '33400130',
      '24241231',
      '02341104',
      '32412221',
      '30221431',
      '12010044',
      '00221004',
      '04032020',
      '44124000',
      NULL,
      '22033410',
      NULL,
      '14030231',
      '01443110',
      '32100333',
      '43342032',
      '00000302',
      '22130321',
      '01234033',
      '01234210',
      '14334322',
      '24012403',
      '42232140',
      NULL,
      '31101232',
      '24400242',
      '11024431',
      '41124040',
      '33023230',
      NULL,
      '04214404',
      '00034420',
      '00201301',
      '31041313',
      '103',
      NULL,
      16,
      5,
      NULL,
      0.898062,
      116.597251,
      3,
      NULL,
      NULL,
      2,
      ' 2-17-1975',
      NULL,
      73.579495,
      NULL,
      16,
      14.538128,
      16,
      9,
      56.259498,
      3,
      11,
      NULL,
      25.082406,
      1.804501,
      0.349098,
      21.455715,
      9.693330,
      NULL,
      14.287228,
      NULL,
      49,
      13.820991,
      61.682990,
      11,
      36,
      NULL,
      1,
      92.973427,
      162,
      78,
      17.824062,
      NULL,
      NULL,
      ' 0-13-1985',
      25,
      29,
      NULL,
      24,
      143,
      106.097383,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13.777963,
      3.491273,
      NULL,
      NULL,
      1,
      ' 9-16-1998',
      2.028556,
      0.121114,
      46.660578,
      2,
      0,
      89,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-15-1996',
      67,
      NULL,
      67,
      49,
      NULL,
      38,
      95,
      66.210652,
      NULL,
      67,
      59.990840,
      60.576335,
      '11-27-1979',
      15.177631,
      17,
      18,
      2.265574,
      70,
      53.047431,
      NULL,
      ' 1- 7-1985',
      NULL,
      10.842262,
      ' 6-25-1983',
      8.128138,
      18.760859,
      3.563848,
      17.732356,
      19,
      13.906615,
      0,
      NULL,
      0.423649,
      58,
      0.316360,
      1,
      1,
      24,
      NULL,
      6.609445,
      NULL,
      0.933696,
      ' 6-10-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      21,
      ' 3- 5-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8- 2-1980',
      3.384964,
      ' 5-12-1979',
      4.968695,
      3.826605,
      NULL,
      144.417093,
      38,
      ' 6-17-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      29,
      ' 9- 1-2003',
      47.718528,
      NULL,
      29.187994,
      ' 5- 6-2000',
      1.492410,
      82.889800,
      '10-21-1978',
      1,
      24.612992,
      8.353762,
      NULL,
      NULL,
      63,
      2,
      124.418234,
      ' 2- 8-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


