set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6905583';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '0',
      NULL,
      '3',
      '0',
      '0',
      NULL,
      NULL,
      '2',
      NULL,
      '4',
      '1',
      NULL,
      '4',
      NULL,
      '0',
      '2',
      '0',
      '3',
      '0',
      '0',
      '0',
      '1',
      '4',
      '',
      '1',
      '',
      '2',
      NULL,
      NULL,
      '1',
      '2',
      NULL,
      '',
      NULL,
      NULL,
      '0',
      '2',
      '1',
      NULL,
      '1',
      '4',
      '4',
      '3',
      '0',
      NULL,
      NULL,
      30,
      41,
      NULL,
      NULL,
      49.451512,
      3,
      NULL,
      '030240',
      NULL,
      ' 6-19-1988',
      ' 1- 4-1997',
      82,
      72.913264,
      13,
      11.485524,
      22,
      12,
      49.231522,
      0.461434,
      8.411788,
      15.219619,
      12.257969,
      3,
      12.705095,
      NULL,
      10,
      5.595893,
      NULL,
      18,
      NULL,
      25.271671,
      5,
      19.387778,
      55.269216,
      10.290705,
      1.450072,
      84,
      NULL,
      NULL,
      133.290096,
      168,
      132.337913,
      ' 9-24-1980',
      36,
      2,
      20,
      10,
      NULL,
      215,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      52,
      8.404877,
      NULL,
      4,
      0.188031,
      6,
      NULL,
      1,
      0,
      1,
      0,
      NULL,
      43,
      1,
      0.892696,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.133753,
      31,
      86,
      59.067080,
      67,
      NULL,
      NULL,
      20.547537,
      59.582219,
      2,
      69,
      6.121105,
      ' 0-20-2000',
      4.556802,
      10.912051,
      NULL,
      1,
      50.788212,
      NULL,
      9,
      NULL,
      13.545710,
      6.949780,
      ' 7- 0-1985',
      2,
      10,
      4.683149,
      9,
      NULL,
      4,
      1.981793,
      17,
      1.495597,
      33.799330,
      NULL,
      NULL,
      9.800642,
      13.379531,
      1.353249,
      0,
      1,
      0.150513,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.058941,
      NULL,
      '11- 7-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0- 4-1981',
      NULL,
      ' 3- 0-1991',
      NULL,
      13.112453,
      ' 8-19-1983',
      13.826211,
      124.815447,
      ' 6-21-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      ' 6-16-1985',
      40.492411,
      32.702492,
      13,
      ' 8- 1-1985',
      NULL,
      83.984547,
      NULL,
      4.939807,
      9,
      11.277734,
      NULL,
      ' 6-25-1991',
      1,
      1,
      97,
      ' 3-23-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


