set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6905583';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '3',
      '2',
      '4',
      '4',
      '1',
      NULL,
      NULL,
      '0',
      '0',
      '3',
      '0',
      '0',
      '1',
      NULL,
      '1',
      NULL,
      '0',
      '2',
      '0',
      '3',
      '1',
      '3',
      '3',
      '',
      '0',
      '',
      '4',
      '2',
      NULL,
      '1',
      '3',
      '',
      '',
      '4',
      NULL,
      NULL,
      '4',
      '1',
      '3',
      '3',
      '2',
      '2',
      NULL,
      NULL,
      '123',
      NULL,
      NULL,
      22,
      '1102044',
      3.810865,
      113.163735,
      2,
      0,
      NULL,
      5,
      '10-27-1982',
      ' 1-26-1998',
      NULL,
      NULL,
      9.462678,
      NULL,
      16,
      2,
      0.326646,
      NULL,
      16.141513,
      13,
      37,
      6,
      26,
      1,
      27.415851,
      9,
      29,
      1,
      71.965636,
      16,
      8.797293,
      18,
      NULL,
      14,
      1.298142,
      1,
      78,
      39.621018,
      175.514371,
      162.030209,
      31.343979,
      ' 7-29-1990',
      58.288234,
      50.098882,
      29,
      16.144023,
      3,
      193,
      ' 6-14-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.219242,
      8.498408,
      0,
      3,
      9.381966,
      ' 8-13-1995',
      1,
      0,
      165.870779,
      NULL,
      1.518557,
      NULL,
      NULL,
      NULL,
      71,
      NULL,
      NULL,
      NULL,
      '10-20-1985',
      NULL,
      7,
      92,
      93.275174,
      NULL,
      37.786306,
      47,
      16.132410,
      64,
      4.189840,
      65.768562,
      80,
      ' 1-12-1982',
      NULL,
      13.621345,
      4,
      NULL,
      37.697480,
      4.382493,
      2,
      ' 2-11-1982',
      15.078640,
      NULL,
      ' 0-25-1991',
      5,
      14,
      16,
      6.964904,
      10.727519,
      3,
      0.918749,
      9.700854,
      1,
      91.536172,
      1.170663,
      NULL,
      3.170434,
      24,
      NULL,
      0.816512,
      0.284421,
      1,
      ' 4-11-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      62,
      NULL,
      ' 8-27-1977',
      NULL,
      NULL,
      NULL,
      9.734429,
      ' 4-10-2003',
      47,
      ' 2-27-1983',
      NULL,
      16.610737,
      ' 9-22-1988',
      101,
      NULL,
      ' 6-14-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13.492806,
      ' 0- 0-1977',
      16.177256,
      53,
      18,
      ' 3-17-2002',
      0,
      NULL,
      ' 7- 2-1974',
      NULL,
      7,
      NULL,
      24,
      ' 7-12-1990',
      50.333692,
      NULL,
      89,
      ' 9-24-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


