set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9206190';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1003',
      '24001410',
      NULL,
      '14104421',
      '03004403',
      '31132323',
      NULL,
      '00221123',
      '44244032',
      '40420210',
      '12233424',
      NULL,
      '20014104',
      NULL,
      '33010021',
      '11322342',
      NULL,
      '31333220',
      '22112241',
      '01003121',
      '14001210',
      '13004412',
      NULL,
      '01201100',
      '01212403',
      '42222043',
      '13302000',
      '34024344',
      NULL,
      NULL,
      '24143122',
      '03033130',
      '03221311',
      '04442002',
      NULL,
      '20000221',
      NULL,
      '34432221',
      '44203004',
      '30404113',
      '23324004',
      '41034212',
      '03332030',
      '40134100',
      NULL,
      '201',
      '42',
      NULL,
      NULL,
      '1232112',
      3,
      0,
      3,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      22,
      NULL,
      31.195000,
      7,
      NULL,
      10.051256,
      27.767302,
      14,
      18.885836,
      1.381210,
      NULL,
      4,
      11,
      8.082021,
      6,
      NULL,
      NULL,
      5.274647,
      32.247539,
      NULL,
      16,
      NULL,
      70.276494,
      12,
      1.877884,
      49.208767,
      75,
      93,
      NULL,
      27.308088,
      157.578275,
      NULL,
      NULL,
      NULL,
      NULL,
      3.928778,
      64,
      148,
      ' 1- 7-1990',
      5.718289,
      NULL,
      2.620430,
      3.108438,
      6.300211,
      3.199318,
      2,
      NULL,
      1.356944,
      1.130678,
      4,
      0.830814,
      3,
      NULL,
      1.735304,
      0.447109,
      2.674697,
      1.700576,
      1.732041,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-25-2000',
      NULL,
      NULL,
      26,
      2,
      36,
      NULL,
      '10-29-1975',
      1,
      0,
      NULL,
      1.823303,
      2.002322,
      94.033366,
      NULL,
      1,
      5.759161,
      1,
      NULL,
      121.059564,
      NULL,
      57,
      NULL,
      95.462521,
      74.717978,
      60,
      64,
      45.022874,
      NULL,
      24,
      14.033539,
      NULL,
      NULL,
      ' 4-27-2003',
      12,
      10,
      3,
      26.499836,
      3,
      0,
      1.664932,
      '11- 8-1975',
      21,
      NULL,
      NULL,
      1,
      0.597092,
      5.125391,
      5.902649,
      10.162811,
      3.262373,
      0,
      2,
      1.209313,
      40.365992,
      1,
      3,
      12,
      9.245276,
      2,
      0.365064,
      3,
      0.465948,
      ' 4-23-1982',
      3.025628,
      5.019833,
      0.186440,
      ' 9-22-1996',
      48,
      11,
      '11- 7-1998',
      NULL,
      NULL,
      NULL,
      27,
      ' 5-28-2001',
      4.655572,
      NULL,
      0,
      NULL,
      ' 3-10-1990',
      NULL,
      NULL,
      NULL,
      0.054170,
      1,
      ' 0- 6-1997',
      7.107632,
      NULL,
      NULL,
      NULL,
      NULL,
      13,
      ' 3- 2-1998',
      62,
      52,
      31,
      ' 5-23-1977',
      3,
      NULL,
      NULL,
      5.514874,
      53,
      0,
      25,
      ' 5-18-1999',
      47,
      1.520328,
      12,
      ' 1-25-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11);
commit;
end;
/


