set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9206190';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0442',
      NULL,
      '41002031',
      '44140422',
      NULL,
      '22410413',
      '30414213',
      '13212413',
      '00000400',
      '14304401',
      '04344021',
      '10102341',
      '32013010',
      '20412342',
      '03001304',
      '04442332',
      '24432010',
      '41414123',
      NULL,
      '40213210',
      '00310143',
      '23010223',
      '20010421',
      '32010313',
      '10140000',
      '00004301',
      '23443332',
      '40143124',
      '10021410',
      '23132011',
      '42232100',
      '24011141',
      '40303021',
      '41213221',
      '12004001',
      '40212320',
      '00342424',
      NULL,
      '04210424',
      '10442224',
      '33221210',
      '34320330',
      '41334023',
      '21402024',
      NULL,
      '220',
      '31',
      NULL,
      NULL,
      '1320224',
      2,
      4.306009,
      3,
      NULL,
      '041041',
      NULL,
      '10-29-1980',
      ' 5-16-1988',
      33.246613,
      NULL,
      5,
      NULL,
      9.628712,
      NULL,
      48.731565,
      10.109841,
      13.219054,
      9,
      7.902468,
      3,
      1,
      7,
      20,
      14.518114,
      5,
      7.563298,
      NULL,
      2,
      57.352665,
      16,
      33,
      6,
      0.734309,
      34.884680,
      81.095547,
      16.898585,
      59.263859,
      44,
      92,
      ' 0-17-1997',
      NULL,
      31,
      18,
      16.399708,
      NULL,
      25,
      '10-22-1999',
      1,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      1.079566,
      NULL,
      NULL,
      0,
      1,
      1.536761,
      1,
      1.374797,
      1.376751,
      1,
      NULL,
      0,
      1.837856,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3- 0-1997',
      0,
      20,
      42.508717,
      1,
      31.667595,
      NULL,
      ' 8- 5-2000',
      3.739734,
      0.528054,
      145,
      0.403560,
      0.509071,
      105.338592,
      2.586594,
      1.938757,
      19,
      NULL,
      NULL,
      NULL,
      ' 9- 8-1975',
      NULL,
      4,
      17.306829,
      51,
      21.426124,
      11,
      41.976625,
      9,
      42.631491,
      NULL,
      9,
      4,
      ' 8-29-1979',
      14.198275,
      0,
      5.851832,
      NULL,
      50.159511,
      NULL,
      3.068816,
      NULL,
      11.678293,
      17.367996,
      ' 5- 5-2003',
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      5,
      1.317741,
      8.473519,
      0,
      5,
      1.185605,
      1.743611,
      18,
      5.700948,
      5.816356,
      0,
      1,
      0,
      ' 7-20-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      54.765945,
      5.307737,
      ' 7-22-1998',
      NULL,
      NULL,
      NULL,
      28,
      NULL,
      17.403104,
      ' 7- 5-1992',
      7.820774,
      13.244803,
      '10-19-1983',
      NULL,
      25,
      ' 7-18-1988',
      NULL,
      1,
      ' 8- 4-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      11.484065,
      ' 4-18-2002',
      18.128756,
      30.770303,
      16,
      ' 4- 8-2000',
      1.811596,
      40.182305,
      ' 7-18-1974',
      3.867029,
      17.915321,
      NULL,
      34,
      ' 2- 7-2003',
      15,
      0.477694,
      NULL,
      ' 6-10-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


