set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9206190';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2032',
      '22442330',
      '40243331',
      '41003002',
      '22021221',
      '43124241',
      '32034344',
      '20433421',
      '11434243',
      '11330332',
      '23302424',
      '21332434',
      '14231410',
      '04401340',
      NULL,
      '43421003',
      '34401322',
      '44140223',
      '34012203',
      '44220221',
      '11101233',
      '21412231',
      NULL,
      '04404140',
      '00320223',
      '21410211',
      '32023220',
      '11103441',
      '42133310',
      '13041311',
      '11210112',
      '34012401',
      '41424330',
      '03133144',
      NULL,
      '01010324',
      NULL,
      '00012412',
      NULL,
      '01411121',
      '33123430',
      '13033412',
      '11011440',
      NULL,
      NULL,
      '202',
      '43',
      NULL,
      5.498673,
      NULL,
      3,
      65,
      1,
      NULL,
      '300222',
      5,
      ' 4-13-1990',
      '10-22-2001',
      51,
      NULL,
      6.848180,
      6,
      21.050226,
      21,
      18.615329,
      6.548193,
      2.721791,
      14,
      3,
      NULL,
      NULL,
      3.098702,
      20.289282,
      1,
      8,
      5.001675,
      2.043590,
      13.193614,
      22,
      NULL,
      72.215973,
      NULL,
      NULL,
      NULL,
      108,
      35,
      118,
      81,
      146.779610,
      ' 7-26-1984',
      50.217354,
      24,
      14.511008,
      13,
      107.055053,
      67.251824,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      64.338153,
      NULL,
      77,
      5,
      53.011232,
      NULL,
      ' 6- 3-2003',
      1,
      0,
      NULL,
      2,
      1.602588,
      21,
      9.295404,
      1.688242,
      35,
      NULL,
      NULL,
      NULL,
      NULL,
      26.124320,
      NULL,
      36,
      14.285269,
      30,
      17.042800,
      48.647394,
      16,
      9,
      NULL,
      6,
      32.570625,
      ' 6-20-2003',
      NULL,
      14,
      1,
      3.222825,
      10.554578,
      18,
      NULL,
      ' 0-12-1983',
      17,
      NULL,
      '11- 0-1982',
      5,
      2,
      1.105968,
      3,
      14.137160,
      2,
      0,
      5.038459,
      1.858043,
      71.249685,
      0.480443,
      0.338232,
      5.582743,
      11.208032,
      NULL,
      1.249690,
      0,
      NULL,
      '11-24-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      86,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      35.810711,
      NULL,
      NULL,
      NULL,
      11.367826,
      5.226083,
      ' 3- 2-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.451532,
      '10-26-1979',
      52.001531,
      NULL,
      20.495753,
      ' 1-27-1992',
      2,
      157.115606,
      NULL,
      6.005320,
      61,
      5.058606,
      55,
      '10-15-1993',
      NULL,
      0.901154,
      NULL,
      ' 9-18-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


