set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9206190';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      NULL,
      '2',
      '1',
      '4',
      '0',
      NULL,
      '0',
      '1',
      '3',
      '0',
      NULL,
      NULL,
      '0',
      NULL,
      '4',
      '4',
      NULL,
      NULL,
      '1',
      NULL,
      NULL,
      '0',
      '3',
      NULL,
      '3',
      '',
      '4',
      '4',
      '3',
      '2',
      '4',
      NULL,
      NULL,
      '4',
      '1',
      '2',
      NULL,
      '1',
      '4',
      NULL,
      '1',
      '1',
      '0',
      '3',
      '103',
      '41040304',
      10,
      22,
      '3120422',
      2,
      NULL,
      1,
      NULL,
      '041023',
      2,
      ' 1-17-1984',
      ' 0- 8-1997',
      106,
      NULL,
      14,
      6,
      7,
      10,
      17,
      7.538000,
      20,
      22,
      NULL,
      8,
      31,
      4.117089,
      19.054687,
      4,
      4.167998,
      13.581582,
      18,
      NULL,
      58.811775,
      18.927072,
      13,
      NULL,
      NULL,
      91,
      NULL,
      23,
      114,
      60,
      19.811682,
      NULL,
      48,
      NULL,
      16,
      5.590618,
      26,
      64.157996,
      ' 9-23-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      32.014929,
      61,
      20.263120,
      7.247229,
      17.226327,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      33,
      NULL,
      3.154981,
      20.613506,
      NULL,
      NULL,
      NULL,
      ' 9- 0-2001',
      29.520266,
      44,
      33.915460,
      42.092677,
      4,
      44.405768,
      0.414262,
      NULL,
      43.205702,
      15.024868,
      36,
      29.492358,
      ' 9- 0-1998',
      6,
      1.285207,
      18,
      NULL,
      15,
      8.028962,
      4,
      ' 1-12-1999',
      NULL,
      1.897238,
      '10-14-1975',
      5.668508,
      NULL,
      13.056916,
      NULL,
      15.700656,
      NULL,
      0.005594,
      1,
      NULL,
      52.648508,
      1,
      0,
      5.650704,
      11.203998,
      NULL,
      0,
      0.914702,
      NULL,
      ' 1-14-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      63.506173,
      10.046100,
      ' 6-20-1986',
      NULL,
      NULL,
      NULL,
      9,
      ' 1-11-1974',
      25.352567,
      NULL,
      11,
      10.051883,
      ' 6- 9-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      12.948354,
      NULL,
      NULL,
      29.262175,
      20.475153,
      ' 2-16-1984',
      0,
      10.321516,
      ' 9-21-1985',
      14.993954,
      19.073092,
      13.921220,
      23.782967,
      ' 1-26-2001',
      56,
      1.596194,
      160,
      ' 2-14-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


