set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9206190';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '0',
      '4',
      '3',
      '3',
      '2',
      '1',
      NULL,
      NULL,
      '1',
      '3',
      '2',
      '2',
      '3',
      '0',
      NULL,
      '1',
      '1',
      NULL,
      '1',
      '3',
      '0',
      '2',
      '4',
      '',
      '1',
      '',
      '2',
      '4',
      '4',
      '3',
      '1',
      '',
      NULL,
      '2',
      '0',
      '0',
      '2',
      NULL,
      '3',
      '0',
      '3',
      '4',
      NULL,
      '3',
      '320',
      NULL,
      NULL,
      73,
      '0101423',
      NULL,
      242,
      NULL,
      0,
      '103304',
      1,
      ' 3-13-1975',
      ' 9-25-1997',
      27.261280,
      151.883837,
      22,
      7.742377,
      9.757736,
      18.414216,
      35,
      12,
      7.733953,
      NULL,
      39,
      13.810626,
      25.414720,
      1,
      8,
      NULL,
      18,
      0.502103,
      85.741115,
      4.230605,
      36,
      15,
      25.122039,
      8.118671,
      NULL,
      26,
      66,
      0,
      165.133781,
      214.868827,
      21,
      ' 5- 2-2001',
      16,
      33,
      26,
      27,
      158.531108,
      184.104285,
      ' 9- 7-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      34.023013,
      NULL,
      7.186331,
      7,
      0,
      1.852238,
      NULL,
      0,
      NULL,
      12,
      1,
      1,
      0.076508,
      1,
      0.529329,
      28.389292,
      NULL,
      NULL,
      NULL,
      ' 8-20-1989',
      27.684517,
      13.209631,
      8,
      34,
      12.658275,
      25.316112,
      47,
      39.595879,
      18.382011,
      32,
      NULL,
      27,
      NULL,
      12,
      6,
      4,
      12.515308,
      51,
      76,
      5.972743,
      ' 2-26-1990',
      13,
      NULL,
      ' 4- 9-1995',
      4,
      21,
      NULL,
      16,
      NULL,
      4,
      0,
      13,
      0,
      108,
      0,
      0,
      NULL,
      23.040287,
      0,
      NULL,
      0.133071,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      77,
      NULL,
      ' 8-13-1994',
      NULL,
      NULL,
      NULL,
      57.376418,
      ' 9-24-1976',
      37,
      ' 6- 5-1990',
      NULL,
      NULL,
      ' 6-11-1994',
      70,
      67,
      ' 1-18-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      10.424483,
      ' 3-19-1982',
      NULL,
      34.797797,
      19.723603,
      ' 7- 3-1982',
      0.838396,
      97,
      ' 7-10-1983',
      15.772147,
      7.288440,
      NULL,
      13.888450,
      ' 3- 6-1999',
      10.108692,
      0,
      37.791026,
      '11-11-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


