set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9756185';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '2',
      '1',
      '0',
      '2',
      NULL,
      NULL,
      '3',
      '4',
      '2',
      '4',
      '2',
      '4',
      '2',
      '4',
      NULL,
      '0',
      '1',
      '2',
      '3',
      NULL,
      '3',
      '4',
      '2',
      '',
      '2',
      NULL,
      '0',
      '3',
      '1',
      '3',
      NULL,
      NULL,
      '',
      '4',
      '2',
      '1',
      '0',
      '4',
      '3',
      NULL,
      NULL,
      '4',
      '2',
      '2',
      '240',
      '40324221',
      37.482539,
      57.463650,
      '2124024',
      3,
      0,
      NULL,
      0,
      '330214',
      1,
      NULL,
      ' 2-10-1997',
      106.050426,
      221,
      12,
      1.655442,
      NULL,
      18,
      4,
      8,
      25.315974,
      20,
      10,
      10.242915,
      NULL,
      6.060537,
      13,
      NULL,
      10.641404,
      7,
      NULL,
      0.238613,
      32,
      0.406222,
      NULL,
      22,
      1,
      4,
      46,
      NULL,
      NULL,
      40.967464,
      23.395457,
      NULL,
      NULL,
      24,
      0,
      19,
      2,
      NULL,
      '11-26-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      34,
      3.567252,
      17.866351,
      16,
      21.509552,
      2,
      ' 7- 1-1977',
      1,
      1.005305,
      110.000777,
      0,
      1,
      30,
      0,
      0.826262,
      3.808804,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      51.075860,
      NULL,
      47.023561,
      NULL,
      81,
      12.215986,
      78.209281,
      4.672961,
      35,
      58,
      39,
      NULL,
      NULL,
      13.962813,
      NULL,
      NULL,
      45.635978,
      NULL,
      4.987068,
      ' 2-21-1976',
      7.262555,
      21,
      '11-26-1981',
      2,
      16.204032,
      13,
      14,
      19,
      7.623756,
      NULL,
      12.875859,
      0.994417,
      113,
      3,
      1.168036,
      17,
      27.102201,
      3.929333,
      NULL,
      1,
      NULL,
      ' 4-27-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      5.919512,
      13.635813,
      ' 1-25-1978',
      NULL,
      NULL,
      NULL,
      14,
      ' 7-10-1995',
      26.111841,
      ' 4- 4-1980',
      1,
      9.810995,
      ' 8- 9-1981',
      92,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      26,
      '10- 1-1999',
      NULL,
      NULL,
      11,
      '10- 3-1996',
      1.202036,
      117.667723,
      ' 4-17-2003',
      0.989752,
      NULL,
      2,
      43,
      '11- 7-1987',
      69,
      0.750845,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


