set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9655289';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '3',
      '1',
      '2',
      '2',
      '0',
      '3',
      '4',
      '1',
      '3',
      '1',
      NULL,
      '3',
      '0',
      '1',
      NULL,
      '1',
      '0',
      NULL,
      '0',
      '1',
      '2',
      '3',
      '3',
      '',
      '4',
      '',
      '2',
      '3',
      '3',
      '1',
      NULL,
      NULL,
      '',
      '0',
      '3',
      '3',
      NULL,
      '4',
      '2',
      '2',
      NULL,
      '4',
      '1',
      '0',
      '444',
      '02330000',
      59.290727,
      15.226013,
      '1444011',
      NULL,
      1,
      NULL,
      0,
      NULL,
      4,
      NULL,
      ' 3-21-1976',
      78,
      NULL,
      18,
      10,
      20.911976,
      2.794294,
      64.778782,
      0,
      NULL,
      NULL,
      10.472550,
      3,
      NULL,
      12,
      25.870148,
      18.205248,
      NULL,
      2.586585,
      16.973526,
      11.660881,
      NULL,
      15,
      14,
      0,
      0,
      NULL,
      NULL,
      26.494287,
      163.286744,
      NULL,
      19.867743,
      ' 0-13-1994',
      16.753420,
      NULL,
      9,
      NULL,
      140.544624,
      NULL,
      ' 7-26-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.207252,
      5.508971,
      1.326242,
      NULL,
      0.704237,
      ' 0-15-1974',
      0,
      0.403410,
      38.165742,
      1,
      0.679922,
      NULL,
      1,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      '11-27-2000',
      114,
      102.468892,
      NULL,
      39,
      104.016897,
      34,
      33,
      111.090514,
      72.074214,
      101,
      75,
      65.716590,
      NULL,
      19.085280,
      12.253366,
      NULL,
      0,
      25.136176,
      30,
      0,
      ' 8-12-1988',
      7,
      4,
      NULL,
      4.064530,
      NULL,
      15,
      18,
      NULL,
      5.500959,
      1,
      13,
      1.944736,
      48,
      NULL,
      1.926800,
      0,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      106,
      8,
      ' 2- 0-1989',
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      15,
      NULL,
      NULL,
      4,
      ' 6-20-1997',
      114,
      NULL,
      ' 0-29-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      24.372154,
      NULL,
      16.658315,
      53,
      NULL,
      '11- 2-1998',
      1,
      94,
      ' 4- 7-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


