set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7907117';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '2',
      NULL,
      '1',
      NULL,
      '0',
      '0',
      '0',
      '4',
      '4',
      '4',
      '3',
      NULL,
      '4',
      NULL,
      '2',
      '4',
      NULL,
      '3',
      '2',
      '1',
      NULL,
      NULL,
      NULL,
      '',
      '0',
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      '3',
      '',
      NULL,
      '3',
      '4',
      '4',
      '4',
      '1',
      '2',
      NULL,
      '2',
      '1',
      NULL,
      NULL,
      '423',
      '42404321',
      NULL,
      37.448638,
      '4044401',
      2.589848,
      1.260268,
      3,
      NULL,
      '234023',
      2,
      NULL,
      '11-25-1984',
      34,
      176.961752,
      0,
      8.193933,
      NULL,
      6,
      32,
      9,
      NULL,
      NULL,
      1,
      7.576612,
      14.070025,
      NULL,
      35.722839,
      NULL,
      NULL,
      NULL,
      36.642094,
      NULL,
      48,
      NULL,
      17.332327,
      0.606695,
      1.211118,
      7,
      110.394906,
      63.228154,
      163.735079,
      78,
      78.937879,
      '11-29-1994',
      4,
      27.259764,
      NULL,
      18,
      45,
      75.754146,
      '11- 5-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      45.571458,
      9,
      1.845418,
      NULL,
      2.035075,
      0.845600,
      NULL,
      NULL,
      0.125358,
      NULL,
      0,
      1,
      NULL,
      5.960192,
      0.580323,
      36.196092,
      NULL,
      NULL,
      NULL,
      ' 3- 4-1987',
      41,
      NULL,
      64.493749,
      84,
      NULL,
      69.446599,
      27,
      99.160553,
      26.541165,
      25.758703,
      50.613268,
      81.969819,
      ' 3-29-1998',
      NULL,
      11,
      7.880069,
      NULL,
      NULL,
      43.987491,
      7,
      NULL,
      16.956735,
      12.590298,
      ' 2-16-2003',
      8,
      9.204600,
      NULL,
      15.198699,
      16.133193,
      9,
      NULL,
      0.805273,
      0.580542,
      56.468836,
      2,
      1,
      2.840436,
      NULL,
      NULL,
      0.613850,
      0.423358,
      1,
      ' 5-11-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      112,
      6.848986,
      ' 7-10-1991',
      NULL,
      NULL,
      NULL,
      32,
      ' 1-16-1991',
      NULL,
      ' 8- 2-1992',
      12,
      7.146743,
      '11-14-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      5,
      ' 6-23-1982',
      NULL,
      11,
      NULL,
      '11-14-1998',
      0,
      NULL,
      ' 7-19-1998',
      0.500590,
      21.439103,
      0,
      NULL,
      NULL,
      29,
      1.828573,
      90.541261,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


