set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7907117';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      '2',
      '1',
      NULL,
      '1',
      '3',
      '2',
      NULL,
      '3',
      '4',
      '0',
      '3',
      '0',
      NULL,
      '2',
      NULL,
      '3',
      '1',
      '3',
      '2',
      '1',
      '1',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      '3',
      '4',
      NULL,
      '2',
      '',
      '',
      '1',
      '1',
      '1',
      '3',
      '1',
      '1',
      NULL,
      '2',
      '1',
      '1',
      '0',
      NULL,
      NULL,
      45.698449,
      42.207354,
      '3334031',
      0.699753,
      5,
      1,
      0,
      '021021',
      3,
      NULL,
      ' 6- 3-1994',
      86.930591,
      287,
      0.411883,
      7,
      NULL,
      8.039006,
      3,
      10,
      5.018005,
      11,
      NULL,
      2,
      3.283931,
      2.839578,
      NULL,
      9,
      9.202652,
      NULL,
      4.658882,
      8,
      45.793056,
      13,
      75.341003,
      NULL,
      0,
      44,
      126,
      67.569536,
      87.824468,
      28.351747,
      123.425786,
      ' 6-26-1981',
      21,
      32.074732,
      15.546348,
      19.673037,
      94,
      154,
      ' 6-25-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      74.506755,
      3.745766,
      5.931807,
      21,
      NULL,
      6,
      ' 0-18-2003',
      0,
      1.065082,
      71,
      NULL,
      1.842710,
      45.614977,
      1,
      0.577218,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-29-1979',
      65,
      33,
      54.490243,
      18,
      87.828338,
      31.914029,
      14.539544,
      57,
      63.720904,
      59.678957,
      66.718089,
      NULL,
      NULL,
      21,
      24.059519,
      6.935116,
      32.904382,
      NULL,
      14,
      NULL,
      ' 6-20-1980',
      22.984408,
      19,
      NULL,
      3,
      3,
      17.134501,
      10,
      2,
      0,
      0,
      13,
      NULL,
      67.136396,
      2.898170,
      0.392059,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1.133334,
      ' 0- 7-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      44,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-15-1995',
      NULL,
      ' 5-26-1975',
      11.903932,
      2,
      NULL,
      70,
      107.235915,
      '11-17-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      21.611543,
      ' 7-17-1991',
      54,
      17.005907,
      30.860740,
      ' 0-20-1993',
      0,
      173,
      ' 1-23-1983',
      1.719874,
      36,
      11,
      40.234650,
      NULL,
      51,
      1.545050,
      158,
      ' 2-20-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


