set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8013144';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '40302403',
      '33112201',
      '42024002',
      '11221311',
      '23332430',
      '14320342',
      NULL,
      '04230024',
      '12333103',
      '40440342',
      '33422102',
      '44110314',
      '00030304',
      '01040112',
      '11222402',
      '10324120',
      '34240203',
      '41410011',
      NULL,
      '44302443',
      NULL,
      '20132120',
      '22412020',
      '22143042',
      NULL,
      '10330433',
      '01422014',
      '23430100',
      '22431312',
      '33002431',
      '21242031',
      '01101300',
      '42113403',
      '33202420',
      '42330412',
      '24222234',
      '41013324',
      NULL,
      '11114242',
      '02323122',
      '34423301',
      '40242401',
      '33302114',
      '11324240',
      '',
      '',
      NULL,
      NULL,
      '0001200',
      NULL,
      0.046111,
      2,
      NULL,
      '223304',
      2,
      NULL,
      ' 5-28-1980',
      4.740386,
      NULL,
      35.916532,
      11,
      21.162223,
      NULL,
      NULL,
      27,
      23,
      22.245211,
      38.830708,
      27.841593,
      25,
      9,
      NULL,
      13.832058,
      NULL,
      14,
      19,
      4,
      5,
      4,
      19,
      4,
      NULL,
      14.445963,
      228.413779,
      15,
      NULL,
      82,
      62.352017,
      ' 4-13-1981',
      33,
      26,
      31.832955,
      26.522024,
      110,
      NULL,
      ' 4-28-2000',
      1.997467,
      2.004340,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0.568143,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-23-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      27.099508,
      25.352363,
      24,
      20,
      24.183126,
      39,
      58.063228,
      16,
      106,
      16.553286,
      63,
      78.148841,
      NULL,
      14.726537,
      2.222340,
      9,
      20.719072,
      7.790860,
      3.742373,
      4,
      ' 7-16-1979',
      NULL,
      6,
      ' 2-25-1987',
      10,
      5,
      5.972293,
      4,
      NULL,
      7.557895,
      NULL,
      5.541404,
      NULL,
      89,
      5.165737,
      1.141825,
      12,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-12-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15,
      1.558069,
      16.795720,
      ' 1-21-1979',
      1.907454,
      142.605942,
      ' 5- 6-1988',
      NULL,
      NULL,
      8.939420,
      NULL,
      ' 0-12-1979',
      NULL,
      1.426177,
      61.654706,
      ' 5- 3-1975',
      NULL,
      NULL,
      NULL,
      7.537503,
      178.832693,
      0,
      58,
      99,
      77,
      19,
      5.026621,
      NULL,
      1.823597,
      5.503837,
      79,
      0,
      NULL,
      41,
      NULL,
      NULL,
      NULL,
      1,
      2,
      48,
      0.871412,
      0.390417,
      172,
      96,
      29.602895,
      NULL,
      0,
      78.706151,
      2,
      0.808494,
      0.164436,
      0.704083,
      1,
      NULL,
      NULL,
      76,
      NULL,
      NULL,
      50,
      NULL,
      0,
      0,
      NULL,
      1.131913,
      NULL,
      NULL,
      30.951891,
      0,
      26.016566,
      NULL,
      14,
      NULL,
      NULL,
      NULL,
      24.873187,
      13.965948,
      34.927587,
      36,
      16.662607,
      8.867751,
      84,
      10.160568,
      8,
      1,
      5.226630,
      NULL,
      NULL,
      0,
      0,
      20.359725,
      NULL,
      ' 6- 4-1991',
      '10- 4-1994',
      ' 7-26-2002',
      ' 2- 6-1993',
      ' 0-11-1995',
      '10- 9-2002',
      NULL);
commit;
end;
/


