set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9606885';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3224',
      '40143300',
      '43023430',
      '33123404',
      '44231132',
      '30303043',
      '14104213',
      '11010331',
      NULL,
      NULL,
      '02444241',
      '43213410',
      '41434110',
      '24442140',
      '22143301',
      '01210320',
      '44042313',
      '12240204',
      '21412144',
      '42424034',
      NULL,
      '40443024',
      '40142214',
      NULL,
      '20132223',
      NULL,
      '13412222',
      '11130421',
      '23431222',
      '02214322',
      '20214013',
      '33313220',
      '32220002',
      '12242240',
      '32323133',
      '13434003',
      '44333411',
      '20423340',
      '11243021',
      '04203013',
      '23210442',
      '20012221',
      '24400211',
      '10031022',
      '11123232',
      NULL,
      '24',
      NULL,
      0,
      NULL,
      2.649209,
      NULL,
      0,
      NULL,
      '403331',
      NULL,
      '11-21-1985',
      ' 8- 1-1993',
      42.559318,
      NULL,
      NULL,
      11.826452,
      8,
      8.422244,
      55,
      12.751064,
      21,
      2.715904,
      37.551769,
      NULL,
      11.155286,
      0,
      24,
      4.013587,
      12,
      8,
      30.306895,
      12.663362,
      3,
      9.786918,
      NULL,
      6.057314,
      NULL,
      8.580744,
      NULL,
      NULL,
      59.160083,
      161.484370,
      157.553807,
      ' 6-14-1977',
      37.178305,
      36.673305,
      14,
      1,
      135.919333,
      47,
      ' 4- 7-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      84,
      13,
      28,
      NULL,
      7,
      0,
      NULL,
      1,
      2,
      92,
      0,
      0.630522,
      74.620440,
      0,
      1,
      32,
      NULL,
      NULL,
      NULL,
      ' 5-10-1979',
      41,
      83.906715,
      NULL,
      85.316176,
      82.090232,
      79.826571,
      70,
      54.156326,
      81,
      25,
      NULL,
      NULL,
      ' 8-11-1985',
      15.990862,
      1.813863,
      1.720793,
      NULL,
      28,
      6,
      2.491982,
      '11- 8-1982',
      11,
      8,
      NULL,
      NULL,
      7.805999,
      NULL,
      NULL,
      11.900856,
      8.710280,
      1,
      3.337660,
      0,
      4,
      1.444237,
      0.992063,
      2.311407,
      NULL,
      12.924171,
      1,
      1,
      0.727726,
      ' 9- 1-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      71,
      NULL,
      ' 1- 1-1978',
      NULL,
      NULL,
      NULL,
      22,
      ' 5-10-1996',
      13.640799,
      ' 6- 2-1983',
      NULL,
      5.965586,
      ' 8- 8-1991',
      NULL,
      20.047486,
      ' 0-25-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      12.520046,
      NULL,
      13.563069,
      3.381321,
      16,
      ' 9- 3-1988',
      NULL,
      61,
      ' 9-24-1978',
      0.318273,
      19,
      19,
      27,
      ' 7- 9-1983',
      8,
      1,
      174.278942,
      ' 3- 3-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


