set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9606885';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      '04334342',
      '02441133',
      '12311104',
      '34323123',
      NULL,
      '32142334',
      NULL,
      '22111011',
      '24112341',
      '20303013',
      NULL,
      NULL,
      '30011300',
      '24402440',
      '14212444',
      '10042121',
      '04102344',
      '04334004',
      '30133230',
      '00024314',
      '44004130',
      '01120034',
      NULL,
      '13403414',
      NULL,
      NULL,
      NULL,
      '33140220',
      '22002024',
      '43004312',
      '40201430',
      NULL,
      '04123322',
      '33031412',
      '23101230',
      '22112213',
      '21034423',
      '43130332',
      '04124111',
      '31424343',
      '13443123',
      NULL,
      '32332230',
      '234',
      '44',
      30.228962,
      16,
      NULL,
      1,
      7.055188,
      3,
      NULL,
      NULL,
      3.215310,
      '11-13-1998',
      ' 6-24-1979',
      99.118707,
      106,
      24.257391,
      8,
      17,
      3,
      NULL,
      11,
      3,
      12.041196,
      3.018009,
      14.060809,
      1,
      NULL,
      23,
      11.494538,
      9.897305,
      NULL,
      NULL,
      0.190943,
      23,
      3.128594,
      23,
      2.109168,
      NULL,
      53,
      3,
      14,
      128.899060,
      83,
      53,
      '10-17-2003',
      3.137430,
      NULL,
      23,
      22.271527,
      86.553020,
      168,
      ' 0-28-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15.035658,
      30,
      NULL,
      5,
      1,
      5.972111,
      ' 6-28-1999',
      1.472019,
      2,
      34,
      0,
      NULL,
      49,
      1.254374,
      1.854411,
      38.922325,
      NULL,
      NULL,
      NULL,
      NULL,
      27,
      85.370392,
      18,
      67,
      56.026202,
      60,
      58,
      26.179182,
      9.978599,
      11,
      52.973014,
      NULL,
      NULL,
      11,
      10.037335,
      7,
      24,
      17,
      6,
      2.963301,
      '11-29-1987',
      12.829720,
      3.576147,
      ' 8- 8-1999',
      7.233094,
      5.951505,
      0,
      1,
      NULL,
      0.817302,
      2.239591,
      5.039911,
      1.541773,
      3,
      4.652804,
      NULL,
      NULL,
      NULL,
      NULL,
      5.618770,
      NULL,
      1.536605,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      29,
      37,
      ' 1-19-1974',
      NULL,
      NULL,
      NULL,
      18.448409,
      ' 5- 5-1977',
      15,
      ' 2- 3-1999',
      7,
      0,
      NULL,
      NULL,
      3.999319,
      '10-14-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      9.243343,
      '10- 6-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      0.145699,
      114,
      ' 7-17-2002',
      17.460947,
      59.830916,
      1.496981,
      4,
      ' 4- 2-1975',
      31,
      NULL,
      61,
      ' 7-19-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


