set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9606885';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '4',
      '0',
      '4',
      '3',
      '3',
      '1',
      '0',
      '4',
      '1',
      '4',
      '4',
      '2',
      NULL,
      NULL,
      '4',
      '1',
      '2',
      '3',
      '1',
      '2',
      '2',
      '4',
      '0',
      NULL,
      '4',
      '',
      '1',
      '3',
      '4',
      '0',
      '3',
      '',
      '',
      NULL,
      '0',
      '2',
      NULL,
      '1',
      '2',
      NULL,
      '3',
      '4',
      '4',
      '4',
      '100',
      NULL,
      46,
      NULL,
      NULL,
      2.582640,
      10.120743,
      0,
      NULL,
      '034301',
      1.994137,
      ' 1- 0-1987',
      ' 4- 0-1974',
      5.646735,
      155.680814,
      10,
      1.589425,
      5,
      7.201812,
      33,
      14,
      17,
      NULL,
      21.004634,
      7,
      NULL,
      10,
      3.313647,
      NULL,
      3,
      11.065401,
      13.096499,
      0.868277,
      NULL,
      10,
      NULL,
      6,
      1.675256,
      11.013853,
      NULL,
      8,
      61.787985,
      NULL,
      13,
      NULL,
      24.912870,
      23,
      2.727563,
      12.418462,
      53.421334,
      30.282105,
      ' 1- 8-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      49.781571,
      8,
      NULL,
      14,
      8,
      6,
      ' 2-21-1992',
      0.915540,
      2,
      131.080160,
      NULL,
      1,
      86.655529,
      NULL,
      1.261059,
      26.026537,
      NULL,
      NULL,
      NULL,
      ' 4-15-1984',
      46,
      66.011243,
      35,
      2,
      NULL,
      12.241671,
      34.027256,
      30,
      8,
      NULL,
      24.497144,
      NULL,
      ' 3-22-1974',
      8.437194,
      0,
      1.583743,
      5.222442,
      3,
      5,
      1.715910,
      ' 5-18-1984',
      5,
      22.381246,
      ' 4- 9-1987',
      5,
      NULL,
      7,
      12.182544,
      2.718644,
      7.605199,
      0.139535,
      3.748202,
      1.616784,
      19.073578,
      NULL,
      0,
      4,
      13.102068,
      5.572095,
      0,
      NULL,
      0,
      ' 0- 3-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      92.910211,
      9.382294,
      NULL,
      NULL,
      NULL,
      NULL,
      29.102515,
      NULL,
      NULL,
      ' 9-12-1989',
      6,
      6.641184,
      '11-21-1988',
      91,
      NULL,
      ' 8-29-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      13,
      '10- 0-1996',
      NULL,
      9.620901,
      14,
      '10- 5-1993',
      1,
      152,
      '10-20-2001',
      NULL,
      13,
      23.692064,
      9,
      ' 2- 7-1986',
      43.219820,
      NULL,
      157,
      ' 1-25-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


