set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8209882';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1304',
      '10413000',
      '21032140',
      '12400343',
      '10212321',
      NULL,
      '33024332',
      '12224331',
      '03241123',
      '21321213',
      NULL,
      NULL,
      '44132100',
      '42313141',
      '01003244',
      NULL,
      '13031100',
      '43343200',
      '03024443',
      '31243312',
      '32303123',
      '10300043',
      NULL,
      '00002020',
      '31024033',
      '13231022',
      '10111012',
      '33444441',
      '34412220',
      '02013033',
      '31431311',
      '11233403',
      '42203223',
      '14430021',
      '13101400',
      '33442413',
      '43143334',
      '20222420',
      NULL,
      '21143023',
      '22200143',
      '21314212',
      '20022343',
      '43300122',
      '32102034',
      '044',
      '20',
      NULL,
      8,
      '2131232',
      NULL,
      0,
      NULL,
      NULL,
      '243413',
      5,
      ' 5-22-1995',
      '10-22-1982',
      206.310638,
      49,
      NULL,
      10.994762,
      12.234918,
      16.789260,
      113,
      4.949377,
      4,
      5.384644,
      39,
      NULL,
      16.228969,
      NULL,
      28.132756,
      1.015994,
      33.889064,
      17,
      28,
      14,
      4.969244,
      27.690607,
      31.307496,
      8.999733,
      1,
      64,
      52.786862,
      135,
      NULL,
      57.504942,
      NULL,
      ' 6-19-1998',
      46.214793,
      57,
      23.613464,
      35,
      NULL,
      NULL,
      ' 7-17-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      22,
      17,
      22.506574,
      7.779631,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      72.080136,
      0,
      0.252906,
      136,
      1,
      0,
      16.809638,
      NULL,
      NULL,
      NULL,
      ' 0-13-2002',
      96.972567,
      NULL,
      96.512857,
      110.913078,
      40.909928,
      95,
      NULL,
      4.037848,
      43,
      44.276276,
      61.141711,
      35.155910,
      ' 4- 2-2003',
      29,
      32.244369,
      25,
      70.756614,
      94.790984,
      30.366940,
      3.801283,
      '11-20-1984',
      9.440499,
      10.393496,
      ' 0-16-1986',
      12,
      0.145151,
      14.229255,
      6,
      1,
      15,
      0,
      19.750844,
      0,
      57.068909,
      11.169178,
      5,
      10.536147,
      7.318373,
      NULL,
      3,
      0,
      0,
      ' 9-16-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-12-1984',
      NULL,
      NULL,
      NULL,
      27.999089,
      ' 4- 6-2002',
      49.602534,
      ' 2-27-1975',
      2.375189,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      ' 9-29-1998',
      NULL,
      18.622476,
      8,
      ' 1-22-1980',
      1.121097,
      59.752292,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


