set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9855678';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      NULL,
      NULL,
      '4',
      '0',
      '1',
      '2',
      '4',
      NULL,
      NULL,
      '3',
      '4',
      '2',
      '4',
      '0',
      '3',
      NULL,
      '4',
      '2',
      NULL,
      NULL,
      '1',
      NULL,
      '1',
      '',
      '4',
      '',
      '4',
      NULL,
      '0',
      '4',
      NULL,
      '',
      '',
      '0',
      '2',
      '0',
      '3',
      '2',
      '3',
      '4',
      '4',
      '1',
      '2',
      '3',
      '200',
      '44440111',
      NULL,
      49,
      '3024222',
      3,
      0.383040,
      3,
      1,
      '323030',
      0.654224,
      NULL,
      ' 1- 8-1975',
      127.433442,
      108.546281,
      14.447608,
      1,
      12,
      10.020623,
      42,
      NULL,
      0.665115,
      10,
      8,
      3,
      17,
      12.856461,
      9,
      7.413588,
      4,
      5.617553,
      NULL,
      2,
      NULL,
      3.528446,
      0,
      11,
      1,
      NULL,
      127,
      39,
      49.844031,
      102.008857,
      90.531773,
      '10- 9-1979',
      43.784949,
      7,
      17.463045,
      12,
      48.752496,
      106,
      ' 7- 0-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      38.750477,
      15,
      28,
      6.800305,
      1.787146,
      ' 0-19-1981',
      0,
      1.844631,
      174,
      NULL,
      3.809624,
      96.896931,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      79.168260,
      65,
      27.553696,
      30,
      9.133595,
      NULL,
      68,
      NULL,
      NULL,
      4,
      NULL,
      84,
      ' 1- 2-1979',
      NULL,
      NULL,
      NULL,
      31,
      30.228921,
      5,
      5.460568,
      ' 7-10-1988',
      0.945964,
      1,
      ' 7-13-2000',
      0,
      8,
      NULL,
      3,
      7,
      NULL,
      3,
      1,
      0,
      20.216408,
      20.869554,
      1,
      3.554452,
      15.645711,
      NULL,
      10.543250,
      10.162783,
      12,
      ' 1-12-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      49,
      NULL,
      NULL,
      NULL,
      NULL,
      42.533810,
      ' 3-29-1982',
      9.741143,
      ' 5-16-2002',
      6.780700,
      NULL,
      ' 4- 5-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      19,
      ' 7-27-1988',
      58.689320,
      NULL,
      NULL,
      ' 6-23-1985',
      0.284105,
      NULL,
      ' 1-26-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


