set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8325901';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0412',
      NULL,
      '00010004',
      '03303024',
      '01410103',
      '10331113',
      '31022223',
      '42014020',
      '43122043',
      '30124444',
      '40122322',
      '41033222',
      '43234430',
      '21112423',
      '32323200',
      '43001032',
      '44313424',
      '02203332',
      NULL,
      NULL,
      '30024410',
      NULL,
      '03410111',
      '34442442',
      '00311032',
      '14201231',
      '30130224',
      '14033014',
      '04302311',
      '00232440',
      '13224223',
      '42044222',
      NULL,
      NULL,
      '10142441',
      '33114044',
      NULL,
      '10144344',
      '44311443',
      '22134044',
      NULL,
      NULL,
      NULL,
      NULL,
      '00404042',
      '',
      '',
      NULL,
      NULL,
      '1113013',
      1.738572,
      1.497330,
      0,
      NULL,
      '030000',
      NULL,
      NULL,
      NULL,
      58,
      NULL,
      15.050350,
      9.319007,
      24,
      14,
      31,
      10,
      NULL,
      6.017850,
      20,
      10,
      8,
      11.075854,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      28.996241,
      117.678688,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-29-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.966208,
      1.569099,
      10,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3.186393,
      0,
      NULL,
      0.638622,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1- 3-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      26.133848,
      60.421790,
      88,
      23,
      78,
      49.611859,
      66.247468,
      38.204608,
      110.001671,
      50.211596,
      NULL,
      2.221377,
      5,
      0,
      57,
      NULL,
      20.766321,
      9,
      '10-18-1995',
      NULL,
      2.684331,
      NULL,
      3.951943,
      4.275836,
      NULL,
      1.821233,
      9,
      2.738944,
      NULL,
      3.911474,
      NULL,
      37,
      16,
      0.086973,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-10-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      545,
      ' 0- 0-1984',
      NULL,
      39.256989,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      89.106749,
      NULL,
      NULL,
      25,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10,
      61.329840,
      1,
      78.846358,
      NULL,
      1.826076,
      1.707496,
      2,
      1.834898,
      1,
      9.693354,
      NULL,
      NULL,
      20,
      50.281747,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.580774,
      58.514391,
      1.770734,
      NULL,
      11.581026,
      0.080619,
      6,
      0,
      102.759702,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3- 2-1992',
      NULL,
      NULL,
      ' 1-16-1976',
      NULL,
      NULL,
      NULL);
commit;
end;
/


