set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8325901';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '21020331',
      '30411334',
      '33324434',
      '04330231',
      '02422123',
      NULL,
      NULL,
      NULL,
      '14230023',
      '20431411',
      NULL,
      '32342123',
      '23433124',
      '00140130',
      '24143442',
      '14311023',
      NULL,
      '02110413',
      '40224220',
      NULL,
      '43241341',
      '14131040',
      '42013324',
      '24032344',
      '23224320',
      '23030320',
      '23214434',
      '23030200',
      '02333420',
      '21440344',
      '13330422',
      '31110021',
      '11001430',
      '32240331',
      '21003123',
      NULL,
      '33332441',
      '13434432',
      '13043213',
      '40142202',
      '04141102',
      NULL,
      NULL,
      NULL,
      '233',
      '11',
      NULL,
      NULL,
      '4330241',
      0.208793,
      75.951595,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-13-1982',
      9.101379,
      NULL,
      32.229248,
      NULL,
      NULL,
      9.383110,
      21,
      13,
      11.020597,
      7.294615,
      24,
      7.770078,
      21,
      13,
      13,
      13.234030,
      NULL,
      3.855331,
      62,
      18.594918,
      11.534374,
      NULL,
      2,
      6,
      2.313753,
      66,
      61,
      80,
      156,
      106.442973,
      119.850178,
      NULL,
      33,
      11,
      15.893841,
      0,
      40.296984,
      142,
      ' 8-26-1980',
      NULL,
      2.530562,
      5.291069,
      20,
      3,
      3,
      2,
      6,
      0.658621,
      1,
      0,
      0.580087,
      1.892752,
      14,
      0.038893,
      0.408950,
      11,
      0.497264,
      0,
      13,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-29-1998',
      6.471433,
      NULL,
      13,
      5.345626,
      3,
      2.588575,
      ' 0- 2-1993',
      1,
      0.299995,
      100,
      0,
      0,
      86,
      1.929459,
      0,
      58.215145,
      NULL,
      NULL,
      NULL,
      ' 7-26-1987',
      34,
      1.974462,
      39.349724,
      NULL,
      81,
      98.305122,
      100.726930,
      46,
      95,
      51.009628,
      37.961221,
      20,
      ' 0- 4-1996',
      0.259871,
      15.173636,
      NULL,
      39,
      0.308550,
      13.043684,
      9,
      ' 3- 4-1974',
      NULL,
      10.061467,
      ' 0-15-1995',
      14.248157,
      17.525633,
      0,
      23.144152,
      11,
      1,
      0.616742,
      NULL,
      NULL,
      72.357591,
      NULL,
      10.220408,
      9,
      8.965919,
      1,
      0.694567,
      3.598042,
      1.765880,
      '11-10-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-18-2003',
      NULL,
      NULL,
      NULL,
      38,
      ' 8- 9-1999',
      NULL,
      ' 1-23-1990',
      11,
      14.386570,
      NULL,
      30,
      95.616805,
      ' 2- 4-2002',
      14.199239,
      4.751821,
      ' 3-20-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      50.210328,
      1.764349,
      9,
      '10- 5-2000',
      2,
      87.983996,
      ' 0-19-1990',
      15.929453,
      29,
      16,
      NULL,
      ' 8-22-1986',
      NULL,
      0.460272,
      111,
      ' 6-10-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


