set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8325901';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1434',
      '04010420',
      '21344332',
      NULL,
      '32011420',
      '10321310',
      '21141214',
      '12242021',
      '14412304',
      NULL,
      '41404413',
      NULL,
      '22221412',
      NULL,
      '13444232',
      '12432142',
      '43430410',
      '02404333',
      '30234430',
      '14130222',
      NULL,
      '20233104',
      '34021411',
      '41214032',
      '10332202',
      '01240104',
      NULL,
      NULL,
      '44322024',
      NULL,
      '42044410',
      NULL,
      '33424034',
      '21331004',
      NULL,
      '34244034',
      NULL,
      '22113043',
      '03422103',
      '43421314',
      '03043100',
      '20001144',
      '20000020',
      '34224421',
      '41114220',
      '120',
      NULL,
      NULL,
      NULL,
      '3424330',
      5,
      NULL,
      2,
      NULL,
      '302310',
      1,
      NULL,
      ' 9-16-1978',
      53,
      NULL,
      15,
      NULL,
      18.498798,
      NULL,
      4.799450,
      NULL,
      NULL,
      6.698081,
      7,
      6,
      7.098454,
      0.571775,
      NULL,
      1.109745,
      0,
      7.760942,
      30.296272,
      17,
      NULL,
      8.073758,
      NULL,
      0.010374,
      0.133264,
      27.501912,
      84,
      45.233678,
      22.328788,
      111,
      4,
      NULL,
      22,
      NULL,
      27,
      4.450457,
      126,
      9.170346,
      ' 0- 0-1997',
      2,
      2.572903,
      NULL,
      1,
      3,
      2,
      NULL,
      0,
      1.472106,
      0.339554,
      5.939490,
      NULL,
      1,
      0,
      NULL,
      1.382624,
      1,
      0.376014,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-27-2002',
      NULL,
      17.903074,
      32,
      23,
      10.377888,
      0.529656,
      '11-14-1990',
      NULL,
      1,
      22.008802,
      3.528436,
      2,
      NULL,
      1,
      NULL,
      21.658589,
      3,
      NULL,
      NULL,
      NULL,
      14,
      11,
      24,
      NULL,
      NULL,
      61,
      90,
      NULL,
      63.086593,
      36.764041,
      92.854406,
      70.466991,
      ' 7-22-1978',
      12.126563,
      8.350210,
      13,
      34,
      0.483257,
      26,
      0.363221,
      '10-26-1977',
      15.197736,
      8.295003,
      NULL,
      5,
      11.588087,
      10,
      1.665651,
      5.888132,
      0.829730,
      0.149599,
      1.668366,
      1.728781,
      37.860087,
      1,
      6,
      10,
      29.465270,
      1,
      3,
      11.057555,
      6.631025,
      ' 0- 7-2002',
      NULL,
      0.937594,
      2,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      13,
      NULL,
      NULL,
      ' 6-23-2001',
      15.103202,
      7,
      '11-19-1982',
      13,
      97,
      ' 9-24-1992',
      2.722594,
      0,
      ' 6-16-1977',
      5.637410,
      4.667174,
      ' 4-10-1983',
      3,
      1,
      15.572629,
      ' 6-15-1998',
      21.561185,
      38.839249,
      8.149854,
      ' 0-17-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.441291);
commit;
end;
/


