set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9774847';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '0',
      '3',
      '1',
      '3',
      '2',
      '4',
      '2',
      '4',
      '0',
      '0',
      '1',
      NULL,
      '3',
      '1',
      '3',
      '4',
      NULL,
      '0',
      '1',
      '2',
      '2',
      '4',
      '4',
      '',
      '0',
      '',
      NULL,
      '0',
      '3',
      '2',
      NULL,
      '',
      '',
      '2',
      '4',
      '1',
      NULL,
      NULL,
      '4',
      '3',
      '0',
      '0',
      '1',
      '0',
      '424',
      '42124033',
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      '223202',
      3.052198,
      ' 9-14-1980',
      '10- 2-1992',
      35.257597,
      1.977446,
      39.474346,
      NULL,
      NULL,
      1,
      14.969552,
      NULL,
      2.435072,
      NULL,
      8,
      0.849781,
      29.398100,
      NULL,
      23,
      12,
      23,
      9,
      NULL,
      13,
      13,
      5,
      121.846569,
      16,
      NULL,
      NULL,
      NULL,
      NULL,
      70,
      62,
      97.653763,
      ' 3-11-1987',
      21.073091,
      43.683546,
      12,
      32,
      197.366171,
      NULL,
      ' 7-20-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      29.902424,
      17.179833,
      3,
      7.149051,
      7,
      ' 7-19-1988',
      NULL,
      1.786876,
      NULL,
      0.960793,
      NULL,
      74.265869,
      4,
      1,
      28,
      NULL,
      NULL,
      NULL,
      ' 4-19-1996',
      NULL,
      24,
      101.408313,
      93,
      16.557488,
      52,
      NULL,
      12,
      1,
      51,
      37,
      16,
      ' 2-12-1977',
      NULL,
      24,
      7,
      73.529220,
      34,
      79.366003,
      7,
      '11-24-1997',
      4,
      15.079166,
      ' 9-11-1980',
      12,
      17,
      24.644790,
      22,
      19,
      9,
      0.631759,
      25,
      0.694547,
      29.459942,
      NULL,
      0,
      25.971762,
      12,
      NULL,
      1.768342,
      1.429317,
      NULL,
      '10- 4-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      107.514019,
      13,
      '10-19-2002',
      NULL,
      NULL,
      NULL,
      29,
      NULL,
      33,
      ' 5-23-1990',
      12,
      NULL,
      NULL,
      39.271562,
      23.395359,
      ' 1-22-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      17,
      '11- 5-1980',
      NULL,
      40.856235,
      50.178413,
      ' 1-21-1987',
      1.878959,
      19,
      ' 4-10-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


