set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9628071';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0021',
      NULL,
      '40233132',
      NULL,
      '20033234',
      '23200341',
      '20112123',
      '22142300',
      '10400030',
      '43103300',
      '32022100',
      '43014042',
      '23410143',
      '23331402',
      '30203002',
      '21004201',
      NULL,
      '13414021',
      '34341123',
      '03222231',
      '03400401',
      '30311131',
      '24334420',
      '23340333',
      '44021123',
      '13200024',
      '11024013',
      '10100313',
      NULL,
      NULL,
      '13430120',
      NULL,
      '44124300',
      '12143414',
      '14013011',
      '01133241',
      '22102420',
      NULL,
      '13130242',
      '30100314',
      '42003001',
      '11344101',
      '24203340',
      '03303232',
      '42231041',
      '023',
      '43',
      NULL,
      NULL,
      '1311032',
      2,
      0.540968,
      0,
      NULL,
      '203132',
      4.375329,
      ' 5- 8-1995',
      ' 4-27-2001',
      NULL,
      NULL,
      17.158496,
      3.526585,
      NULL,
      9.639865,
      58,
      17,
      17.297077,
      NULL,
      34.122870,
      1.181825,
      3.310979,
      NULL,
      23.044426,
      13.507623,
      9.679690,
      16.080814,
      NULL,
      14.577424,
      NULL,
      NULL,
      37,
      22,
      NULL,
      128,
      164.424491,
      104,
      163,
      244.855929,
      129,
      ' 1- 1-1984',
      5.629012,
      6,
      8,
      23,
      19.868647,
      201,
      ' 1- 1-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      69.710981,
      42,
      0.213316,
      12,
      8.506781,
      3,
      ' 2- 1-1974',
      0.721265,
      1,
      72.432247,
      NULL,
      3,
      50,
      1,
      3,
      61,
      NULL,
      NULL,
      NULL,
      ' 0- 6-1984',
      17,
      66,
      97,
      80.061702,
      NULL,
      41.840873,
      103,
      NULL,
      NULL,
      44.997577,
      64.388677,
      12.318641,
      '10-13-2003',
      26.246938,
      2,
      NULL,
      57,
      21.217644,
      90,
      4.728753,
      '10-28-1986',
      9,
      28,
      ' 6-15-1998',
      0.193194,
      8,
      14.979488,
      2.805678,
      NULL,
      NULL,
      0.418485,
      11,
      1.767650,
      11,
      0,
      1,
      2.841692,
      NULL,
      0,
      1.667329,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      207.411483,
      NULL,
      '11-23-2000',
      NULL,
      NULL,
      NULL,
      1.493902,
      ' 0- 4-1997',
      NULL,
      ' 6- 6-1979',
      14,
      3,
      NULL,
      25,
      36,
      ' 3-26-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      21.519846,
      ' 6-23-1989',
      16,
      45,
      22.931193,
      ' 6- 8-2003',
      NULL,
      NULL,
      ' 8-22-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


