set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9111327';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2020',
      NULL,
      '00401023',
      '31214023',
      '23400403',
      '33212232',
      NULL,
      '44211002',
      '01421102',
      '44230211',
      '03014243',
      '20110010',
      '44234313',
      NULL,
      '12022021',
      '41223210',
      NULL,
      '24110311',
      '11313022',
      '20103113',
      '04022413',
      NULL,
      NULL,
      '23102441',
      '01103242',
      '10122321',
      '10141310',
      '30024121',
      '24043410',
      '33003423',
      '12001133',
      '11403044',
      '20443321',
      NULL,
      '34431103',
      '01111230',
      NULL,
      '23444121',
      '30001440',
      '44001130',
      '43321232',
      '31300402',
      '42213302',
      '32210043',
      '03302230',
      '310',
      '04',
      NULL,
      NULL,
      '1110310',
      0.953232,
      0.123014,
      3,
      NULL,
      NULL,
      4,
      NULL,
      ' 4- 4-1988',
      2.847731,
      NULL,
      36.324642,
      5.611846,
      15,
      9,
      NULL,
      11.649365,
      9,
      0,
      NULL,
      0.690372,
      NULL,
      17.360119,
      25,
      3,
      NULL,
      3,
      NULL,
      3.080180,
      NULL,
      11,
      5.604619,
      13,
      NULL,
      NULL,
      39,
      102,
      23.697084,
      134,
      NULL,
      ' 5- 2-1983',
      NULL,
      38.122129,
      19,
      NULL,
      17.352990,
      25.807022,
      '10-28-1991',
      0,
      0.256876,
      0.673946,
      0.576584,
      NULL,
      0,
      7.735092,
      0.921183,
      0.448412,
      1.283969,
      1.206455,
      0.014379,
      1.238069,
      0,
      0.160427,
      0.343454,
      1.565414,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-11-1974',
      24.026192,
      53.036238,
      11.037328,
      3,
      13.950990,
      7.509798,
      NULL,
      1,
      1.257542,
      39,
      1,
      0,
      1.951176,
      0.312332,
      1.908909,
      100.905890,
      0,
      1,
      81.502533,
      NULL,
      58.294713,
      49.611436,
      40.875504,
      93,
      73,
      NULL,
      0,
      35,
      70.712961,
      NULL,
      43.936774,
      NULL,
      NULL,
      21.987985,
      14,
      16.156726,
      4.957686,
      47,
      33.816486,
      NULL,
      ' 4- 4-1988',
      14,
      18.921578,
      ' 8-21-2001',
      18,
      31.496585,
      29.100148,
      17,
      2,
      NULL,
      1,
      NULL,
      NULL,
      112,
      0.842126,
      1.636864,
      18.120467,
      4,
      0,
      1,
      1,
      NULL,
      ' 9- 8-1975',
      2,
      1.792278,
      NULL,
      NULL,
      99.908927,
      0.614574,
      ' 8- 8-1993',
      8,
      NULL,
      ' 7- 5-1997',
      8,
      '10- 3-1992',
      17.391587,
      ' 1-25-2002',
      NULL,
      6.890407,
      ' 3-14-1975',
      NULL,
      48.162839,
      ' 7-27-1987',
      NULL,
      28.709516,
      '10-14-1997',
      1.320448,
      3,
      ' 6-16-1991',
      NULL,
      2,
      1,
      ' 9-20-1975',
      19.363663,
      10,
      NULL,
      ' 0-14-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.991978);
commit;
end;
/


