set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8705689';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0040',
      '01414101',
      '20100220',
      '10230111',
      '00144441',
      '31420041',
      '34440021',
      '03323231',
      '30041444',
      '41412404',
      '41331422',
      '33431211',
      '01324031',
      '40301333',
      '31241141',
      NULL,
      NULL,
      '30020033',
      '31100033',
      NULL,
      '24343413',
      '11044033',
      '30101042',
      NULL,
      '34033034',
      '40220440',
      '22034134',
      '43102133',
      NULL,
      '00021311',
      NULL,
      '04021021',
      '12030230',
      '41122404',
      '34400341',
      '32012002',
      '44232342',
      '34233421',
      '40100410',
      '13010331',
      NULL,
      '01443430',
      NULL,
      '12204232',
      NULL,
      '231',
      '03',
      11.505532,
      4.487456,
      '1142232',
      1.583765,
      11.414709,
      3,
      NULL,
      '242214',
      2.542272,
      ' 6- 7-1989',
      ' 0-24-2001',
      5.246307,
      NULL,
      28.976854,
      0.214757,
      NULL,
      NULL,
      8,
      6,
      33.567409,
      9,
      33.883973,
      12.045790,
      38,
      NULL,
      NULL,
      25,
      15.575747,
      NULL,
      24,
      28,
      NULL,
      11.007004,
      37,
      5,
      NULL,
      6,
      140.522763,
      NULL,
      NULL,
      171.487764,
      23,
      NULL,
      18,
      26,
      29.509766,
      31.940877,
      136,
      207.335793,
      ' 6- 6-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      17,
      24.083235,
      18.311004,
      0,
      0,
      7.671502,
      '11- 5-1990',
      0,
      NULL,
      49.738549,
      NULL,
      0.514837,
      165,
      1,
      1,
      37,
      NULL,
      NULL,
      NULL,
      ' 0-18-1978',
      NULL,
      NULL,
      52.232302,
      104,
      NULL,
      1.744378,
      NULL,
      NULL,
      45,
      NULL,
      11.238185,
      22.528924,
      ' 8-25-1978',
      0.769025,
      12.266343,
      11,
      19,
      41.889879,
      47,
      7.888856,
      ' 9- 9-1981',
      0,
      9,
      ' 0-24-1987',
      NULL,
      11.199885,
      13,
      15,
      28,
      9,
      1.066516,
      10.045592,
      NULL,
      112.924526,
      0,
      0.747623,
      NULL,
      15,
      4,
      NULL,
      0,
      0,
      ' 6- 8-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      30,
      0.374817,
      '11- 6-1984',
      NULL,
      NULL,
      NULL,
      33,
      ' 9-17-1975',
      NULL,
      ' 0-26-1993',
      NULL,
      4,
      NULL,
      59.096434,
      45.246299,
      ' 6-24-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      29,
      ' 5-10-1996',
      31,
      5,
      10.124810,
      ' 7-27-1984',
      0,
      NULL,
      ' 0-12-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


