set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8705689';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '23011421',
      '22212012',
      '41112342',
      '12234322',
      NULL,
      '42024102',
      NULL,
      '23404203',
      '24400202',
      '33340420',
      '00302433',
      '42024413',
      '04244300',
      '40421000',
      '41222330',
      NULL,
      '12440232',
      '24223304',
      '41111422',
      '10010204',
      '00301402',
      '10423044',
      '14314340',
      '01242133',
      NULL,
      NULL,
      '31441332',
      '23400134',
      '33232314',
      '04413333',
      '23413400',
      '21031310',
      '32113212',
      '12413003',
      NULL,
      '44420422',
      '01421424',
      '12141421',
      NULL,
      NULL,
      NULL,
      '00131204',
      '41204431',
      '24400141',
      '221',
      '33',
      2.487352,
      13.905749,
      '4001223',
      3.691446,
      0,
      0,
      NULL,
      '010431',
      NULL,
      ' 0-19-1999',
      ' 1-11-1995',
      58.674108,
      64.023539,
      49,
      2,
      17,
      9,
      50.932123,
      13.998966,
      15.781838,
      29.992615,
      16.926799,
      2.653476,
      3,
      21.500836,
      17.493401,
      21,
      NULL,
      16.114968,
      6,
      28,
      NULL,
      NULL,
      134,
      10,
      NULL,
      132.802415,
      37.339904,
      74.286243,
      49,
      106,
      211,
      ' 4-17-1989',
      37,
      29,
      35,
      30.208110,
      NULL,
      102.997377,
      NULL,
      1,
      2.848639,
      NULL,
      0.111113,
      1,
      NULL,
      NULL,
      1,
      1,
      0.749013,
      NULL,
      1,
      1.486201,
      0.906603,
      1,
      1,
      NULL,
      1,
      1.858373,
      1.952024,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5- 5-1987',
      60,
      5.035671,
      2.637396,
      12.700810,
      3,
      9,
      ' 8-10-1991',
      0.097135,
      NULL,
      115,
      NULL,
      3,
      16,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-28-2001',
      117,
      12.020240,
      27.424537,
      48.407565,
      39.167914,
      46,
      79.103906,
      NULL,
      6.085281,
      113.405701,
      93,
      39.104789,
      ' 9-21-1994',
      7.226059,
      3,
      NULL,
      54,
      85.297452,
      NULL,
      4,
      ' 5-12-1974',
      20.137533,
      NULL,
      NULL,
      NULL,
      2,
      14,
      8,
      11.826248,
      9.421407,
      1.487528,
      NULL,
      1.140481,
      3,
      5.654970,
      8.025126,
      5,
      NULL,
      1.364689,
      1.835242,
      1.035501,
      NULL,
      '10-29-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      198,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      ' 9-11-1996',
      6.366843,
      ' 2-11-1991',
      1.867868,
      13.537697,
      ' 4-17-1984',
      NULL,
      44,
      ' 5-13-1975',
      NULL,
      7.853573,
      '10-19-1976',
      NULL,
      NULL,
      NULL,
      3,
      3,
      3,
      NULL,
      53,
      8,
      NULL,
      ' 7-16-1978',
      0,
      27.282421,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


