set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9803061';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '3',
      NULL,
      '4',
      NULL,
      '0',
      NULL,
      '2',
      NULL,
      '2',
      '2',
      '1',
      '0',
      '2',
      NULL,
      '3',
      '4',
      '4',
      '2',
      '0',
      '0',
      '0',
      '3',
      '0',
      NULL,
      '0',
      '',
      '1',
      '3',
      NULL,
      '4',
      '4',
      NULL,
      '',
      NULL,
      '2',
      '4',
      '1',
      '1',
      '3',
      '0',
      '1',
      '1',
      '1',
      '2',
      NULL,
      '21202234',
      NULL,
      12.795419,
      '3033420',
      0,
      1.659061,
      1,
      NULL,
      '404412',
      0.539153,
      ' 1-25-1986',
      '11- 7-1998',
      76.196039,
      139.712570,
      42,
      9.575082,
      NULL,
      14,
      16,
      2,
      NULL,
      13,
      3,
      9.572059,
      NULL,
      NULL,
      3,
      19.397431,
      3.247306,
      10,
      44.275251,
      16.902806,
      7,
      18,
      59,
      7,
      1,
      NULL,
      12,
      86,
      125.577206,
      48,
      123.434559,
      ' 0-26-1979',
      9,
      14,
      0,
      5,
      NULL,
      186,
      '10-12-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.612785,
      152,
      NULL,
      3,
      68.281674,
      1.290992,
      NULL,
      33,
      NULL,
      NULL,
      NULL,
      ' 6-18-1981',
      28.661985,
      72.782077,
      84.227478,
      72.629952,
      NULL,
      NULL,
      40,
      NULL,
      25,
      61.983101,
      6.047139,
      61.568568,
      '11-23-1999',
      3.673623,
      4.779449,
      8,
      6.584735,
      51.259106,
      66.484761,
      1.271770,
      ' 2-19-1988',
      1,
      16.746429,
      ' 6-16-1983',
      1.777334,
      5,
      0,
      3.566833,
      1.082332,
      0,
      1,
      9.128148,
      0.296839,
      7.810709,
      NULL,
      1.575807,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7- 4-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      40,
      1,
      ' 4-15-1998',
      NULL,
      NULL,
      NULL,
      12.696517,
      ' 4-24-1985',
      29,
      ' 2-25-1984',
      5.200080,
      3,
      ' 3-24-1997',
      NULL,
      62.180612,
      ' 8-22-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      6.905787,
      ' 0-29-1977',
      25.395550,
      16.561755,
      NULL,
      ' 4-13-1977',
      1.796057,
      20,
      ' 1- 8-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


