set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8520583';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0013',
      '24404001',
      '41012041',
      '22413133',
      '22043234',
      '24001401',
      '41440141',
      '30030304',
      '01230103',
      NULL,
      '22440243',
      '12324132',
      '32424322',
      '20200204',
      '14233310',
      '43301414',
      '40430244',
      '42210304',
      '21332121',
      '04120344',
      '34332002',
      '30412043',
      '41244044',
      '31302214',
      '01400103',
      '30024243',
      '20123332',
      NULL,
      '14011400',
      NULL,
      '31412342',
      NULL,
      NULL,
      NULL,
      '34204132',
      '44133123',
      '21020230',
      '10130041',
      '40410421',
      '31344102',
      '04122410',
      '00010123',
      '34442211',
      '11041223',
      NULL,
      '422',
      NULL,
      NULL,
      NULL,
      '1240122',
      0,
      0.268836,
      0,
      NULL,
      '002424',
      1.321051,
      ' 2- 5-1989',
      NULL,
      36.437772,
      NULL,
      3,
      NULL,
      11,
      12.487529,
      NULL,
      16.962482,
      6.210400,
      NULL,
      NULL,
      NULL,
      32.051524,
      4.860314,
      23.734634,
      24.411224,
      NULL,
      16,
      32.402269,
      12.188832,
      30,
      1.007901,
      119,
      22.655567,
      1.847523,
      36.119839,
      NULL,
      90.269963,
      NULL,
      NULL,
      137,
      ' 3- 7-1990',
      NULL,
      NULL,
      22,
      26,
      NULL,
      213.263744,
      ' 5- 1-1979',
      2,
      0.619415,
      5,
      3,
      NULL,
      1,
      4,
      1.064974,
      NULL,
      0,
      0.948888,
      1,
      0,
      NULL,
      NULL,
      1.128771,
      1,
      1,
      1.727772,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8- 2-2000',
      NULL,
      17,
      12,
      4,
      0.570233,
      3.884376,
      '10- 7-1986',
      1.226637,
      NULL,
      154.312092,
      0,
      0.822958,
      NULL,
      3,
      1,
      4.246198,
      0,
      1,
      128,
      NULL,
      63,
      67,
      53.302711,
      NULL,
      38,
      100.604430,
      20.488602,
      100.530562,
      98,
      0,
      NULL,
      NULL,
      NULL,
      11.697991,
      NULL,
      15,
      NULL,
      51,
      81.578516,
      8.432592,
      NULL,
      7.233348,
      3.533480,
      ' 6- 3-1989',
      NULL,
      NULL,
      12,
      17,
      7.987290,
      2.305774,
      0,
      NULL,
      1.261626,
      NULL,
      1.484130,
      NULL,
      NULL,
      7.078497,
      2.483437,
      0,
      1.775272,
      0.435445,
      ' 0-24-1989',
      1,
      1,
      3,
      NULL,
      140.512405,
      NULL,
      ' 4-24-1979',
      NULL,
      0.616235,
      ' 3-14-1998',
      29.812789,
      '11- 0-1980',
      28,
      ' 7-17-1998',
      8.091819,
      16.796303,
      ' 2- 1-1974',
      15.301770,
      12,
      ' 7-13-1992',
      12.893605,
      2,
      ' 4- 3-1980',
      NULL,
      8,
      ' 6- 5-1979',
      0,
      0,
      NULL,
      ' 7-12-1975',
      NULL,
      43,
      2,
      ' 4-24-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.092517);
commit;
end;
/


