set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9875215';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '1',
      '0',
      '2',
      '1',
      '0',
      '4',
      '3',
      '4',
      '2',
      '4',
      NULL,
      '2',
      '3',
      '4',
      '2',
      '1',
      '4',
      '3',
      NULL,
      '4',
      '4',
      '4',
      '1',
      '',
      '0',
      '',
      '2',
      '1',
      '3',
      '2',
      '4',
      '',
      '',
      '3',
      NULL,
      '4',
      '3',
      '2',
      NULL,
      '0',
      '3',
      '0',
      '4',
      NULL,
      '033',
      '02201403',
      61,
      46.255578,
      '3203412',
      3.576066,
      1,
      2,
      1,
      '113111',
      NULL,
      ' 5-14-1982',
      ' 9-13-1977',
      NULL,
      252.008780,
      18,
      12,
      16.830832,
      11,
      29.286056,
      NULL,
      NULL,
      3,
      23,
      0.364438,
      2.239511,
      6.745026,
      15,
      11,
      8,
      NULL,
      32.232908,
      3,
      28.379495,
      7,
      60.165990,
      NULL,
      1.040226,
      26,
      106,
      46.989673,
      9,
      47.307279,
      150,
      ' 3-12-1979',
      6.460077,
      20,
      11,
      16,
      132.217096,
      181.125193,
      ' 6-17-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13.171249,
      NULL,
      NULL,
      81.919004,
      1.625243,
      0,
      ' 7-18-1976',
      NULL,
      0,
      136,
      0,
      NULL,
      125.677253,
      1,
      NULL,
      0.168294,
      NULL,
      NULL,
      NULL,
      ' 7-28-1982',
      NULL,
      NULL,
      NULL,
      8.413047,
      35.210037,
      93,
      27.675004,
      76,
      4,
      NULL,
      66.279343,
      NULL,
      NULL,
      13.226904,
      NULL,
      13,
      16,
      21,
      12,
      NULL,
      ' 1-22-1998',
      18,
      NULL,
      NULL,
      9.394816,
      11,
      17.854131,
      17,
      4.728412,
      1,
      0,
      6.010720,
      0,
      0,
      0.713265,
      NULL,
      1.964593,
      0,
      5.682364,
      0.078959,
      0,
      1.901930,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      131.815027,
      1.147151,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-16-1984',
      NULL,
      ' 1-20-2000',
      10,
      2.837060,
      ' 2-14-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      25,
      ' 1-28-1987',
      51.144308,
      33,
      27,
      NULL,
      NULL,
      21,
      '11- 4-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


