set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9532151';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0242',
      '33400200',
      '14423242',
      '14043224',
      '03114432',
      '34331343',
      '43104224',
      '31034431',
      '34313320',
      '21004242',
      '11314321',
      NULL,
      NULL,
      NULL,
      '24213044',
      '44031233',
      NULL,
      '02110302',
      '31114313',
      '10104220',
      '41314204',
      '30111212',
      NULL,
      '31031221',
      '33332124',
      '04400223',
      NULL,
      '20033221',
      '42313123',
      NULL,
      '32232001',
      '34221332',
      '34413424',
      '32022103',
      NULL,
      NULL,
      '43130311',
      '42041012',
      '12412334',
      NULL,
      NULL,
      '03213110',
      '21131114',
      '04304223',
      '12011313',
      '041',
      '01',
      NULL,
      NULL,
      '4204240',
      NULL,
      0.541558,
      0,
      NULL,
      '422412',
      3,
      '10-22-1999',
      NULL,
      74,
      NULL,
      NULL,
      4,
      31.533888,
      4.468190,
      63,
      7,
      16,
      16.728045,
      36,
      NULL,
      40.244757,
      17.444616,
      7.814847,
      NULL,
      31,
      19,
      8.162766,
      4.070655,
      17,
      NULL,
      NULL,
      21,
      1,
      NULL,
      48.019723,
      31,
      207.276074,
      113.227615,
      NULL,
      ' 7-10-1985',
      50,
      NULL,
      NULL,
      18.150454,
      12,
      11,
      NULL,
      0,
      1.026304,
      NULL,
      NULL,
      0,
      1,
      0.996722,
      1,
      1,
      1.747409,
      NULL,
      NULL,
      NULL,
      4,
      0,
      NULL,
      NULL,
      1.978053,
      0,
      4.888490,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-28-1989',
      NULL,
      16.223608,
      2.921804,
      9,
      7,
      13,
      NULL,
      1.451702,
      0.598130,
      128,
      NULL,
      NULL,
      99.420379,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15,
      73.341512,
      NULL,
      NULL,
      20,
      72.636561,
      24.182795,
      77.572614,
      18.628984,
      NULL,
      87.661712,
      ' 7- 6-1980',
      NULL,
      18.399728,
      39.781479,
      NULL,
      NULL,
      90,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.285726,
      18,
      7,
      5,
      5.066211,
      12,
      0,
      119,
      2.560930,
      NULL,
      NULL,
      24,
      1,
      NULL,
      NULL,
      0,
      ' 7-26-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      69,
      1.654414,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-20-1990',
      NULL,
      NULL,
      20,
      16.406569,
      ' 4-12-1998',
      63,
      29,
      ' 6-19-1981',
      11.910560,
      7.182015,
      '11-25-1977',
      NULL,
      NULL,
      NULL,
      0,
      1,
      7,
      NULL,
      21,
      11,
      9,
      ' 9- 9-1974',
      0.285547,
      46,
      ' 4-22-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


