set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9325317';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4244',
      NULL,
      NULL,
      NULL,
      '03432044',
      '31042040',
      '14441000',
      '23131003',
      '02331313',
      '44334343',
      NULL,
      '21223203',
      '00110204',
      NULL,
      '23032433',
      '30223334',
      '44320211',
      '02044211',
      NULL,
      NULL,
      '01120242',
      '20444434',
      NULL,
      '11140140',
      '20430011',
      '31434303',
      '42240222',
      NULL,
      NULL,
      '13100334',
      '14430232',
      '30400213',
      NULL,
      '32111130',
      '40012103',
      NULL,
      NULL,
      NULL,
      '13424414',
      NULL,
      NULL,
      '31314440',
      '32322443',
      '02324334',
      '14344424',
      '002',
      '43',
      NULL,
      NULL,
      '2312102',
      NULL,
      0,
      2,
      NULL,
      '044332',
      2,
      ' 8-15-1986',
      ' 8-16-1985',
      NULL,
      NULL,
      26.246263,
      NULL,
      8.950779,
      NULL,
      101,
      13,
      12,
      14.636748,
      32.458251,
      2,
      43,
      NULL,
      17,
      9,
      30,
      18,
      13.047626,
      7.424850,
      35.540954,
      NULL,
      86,
      3,
      0.022631,
      78.013182,
      76,
      NULL,
      NULL,
      87.880079,
      56,
      '10-20-1982',
      51,
      NULL,
      33.873971,
      NULL,
      NULL,
      93.598363,
      ' 0- 1-1982',
      1.242228,
      NULL,
      1,
      NULL,
      1,
      0.623329,
      0.464131,
      3.076524,
      0.524768,
      0.925081,
      NULL,
      1,
      0,
      0.415154,
      1.749421,
      1.933879,
      1,
      1,
      0.125121,
      0.156430,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4- 4-1977',
      105,
      17.147723,
      4.333360,
      10,
      3.493309,
      6,
      NULL,
      0,
      0,
      141.077904,
      0,
      NULL,
      82,
      0.953083,
      0,
      53.957215,
      NULL,
      NULL,
      NULL,
      ' 4-21-1999',
      75.211467,
      13.036904,
      NULL,
      8.761703,
      55,
      65,
      25,
      32.887499,
      59.126099,
      105,
      60.678985,
      1.361082,
      NULL,
      1.971675,
      4,
      NULL,
      20,
      NULL,
      1.152944,
      11.584779,
      '11-14-1992',
      NULL,
      24,
      ' 8-21-1986',
      0.901228,
      7,
      16.589936,
      NULL,
      NULL,
      NULL,
      NULL,
      17.838867,
      0,
      56.374501,
      NULL,
      NULL,
      11.900398,
      23.802024,
      1,
      1.140809,
      1.783964,
      NULL,
      ' 1-13-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      126.959337,
      NULL,
      ' 3-11-1986',
      NULL,
      NULL,
      NULL,
      35,
      '11- 5-1984',
      NULL,
      ' 6- 0-1981',
      2.370337,
      2.959560,
      ' 9-14-1977',
      9,
      70,
      ' 0-24-1993',
      NULL,
      7,
      ' 8-28-1977',
      NULL,
      NULL,
      NULL,
      0,
      0,
      11,
      ' 2-26-1983',
      65.899435,
      28.905912,
      38,
      ' 8-23-1987',
      0,
      78,
      ' 7-19-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


