set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7001218';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2413',
      '23231142',
      '33404410',
      '31420022',
      NULL,
      NULL,
      '23124441',
      '01131132',
      NULL,
      '10313004',
      '32124214',
      '33214112',
      '44103330',
      NULL,
      '00232133',
      '43140034',
      NULL,
      '32434041',
      '41430230',
      '00320042',
      '44202312',
      '13044014',
      NULL,
      NULL,
      '23243243',
      '11303403',
      '24122412',
      '11022144',
      '00032131',
      '10332231',
      '31032234',
      '33300232',
      '40244431',
      '34404443',
      '21314310',
      '43002241',
      '01344132',
      NULL,
      '41240402',
      '31130332',
      '21322442',
      '01122230',
      '23333140',
      '00344132',
      '23112041',
      NULL,
      '',
      NULL,
      NULL,
      '1412341',
      1,
      1.611692,
      1,
      NULL,
      '011010',
      3.533680,
      NULL,
      NULL,
      1,
      NULL,
      4.836911,
      13,
      25,
      14,
      87,
      NULL,
      29,
      6,
      13.534401,
      4.308475,
      NULL,
      NULL,
      3,
      0,
      6.342772,
      4.958382,
      34,
      NULL,
      5,
      3,
      15.158514,
      7.260867,
      NULL,
      97,
      142.141398,
      21.692148,
      134,
      54.634171,
      122,
      NULL,
      54.963420,
      16.504832,
      3.607612,
      NULL,
      18,
      212.794879,
      NULL,
      13.905082,
      9.950874,
      11,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.384443,
      3,
      0,
      2,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      33,
      76,
      29.489946,
      95,
      18.386946,
      NULL,
      9.485727,
      81,
      57,
      NULL,
      NULL,
      6.588103,
      NULL,
      2.117837,
      NULL,
      NULL,
      5,
      50.990239,
      4,
      2,
      NULL,
      NULL,
      4,
      NULL,
      4,
      NULL,
      NULL,
      12.147644,
      16,
      6,
      NULL,
      6.186092,
      NULL,
      59,
      8.889877,
      6.625424,
      10.777399,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      51.393806,
      8,
      NULL,
      NULL,
      2.122580,
      137.454174,
      NULL,
      7.374853,
      26,
      NULL,
      NULL,
      NULL,
      68,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      52,
      NULL,
      60,
      48,
      98,
      24.555867,
      20,
      30,
      8.130031,
      2.489355,
      31.964370,
      1.743869,
      1,
      60,
      1.013258,
      NULL,
      115,
      1,
      0,
      185.865271,
      NULL,
      5.370454,
      28.011042,
      13,
      NULL,
      32.585472,
      0.791866,
      43,
      1.018871,
      0.040919,
      0,
      NULL,
      1,
      1.686810,
      NULL,
      26.124217,
      33,
      4,
      50.311720,
      26,
      1.023721,
      NULL,
      5.288582,
      1,
      3,
      2.291270,
      2.005944,
      1.918125,
      36,
      0.245661,
      NULL,
      2.827507,
      NULL,
      15.369769,
      6.840080,
      5,
      9.738086,
      43.100077,
      NULL,
      5,
      15,
      4,
      NULL,
      0,
      1,
      1,
      1.281276,
      NULL,
      4,
      44,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


