set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7836245';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4310',
      '31113444',
      '13100233',
      '24231314',
      '03400313',
      NULL,
      NULL,
      NULL,
      '12001112',
      NULL,
      '00444202',
      '24014220',
      NULL,
      '34103433',
      NULL,
      NULL,
      '03113222',
      NULL,
      '01114024',
      '30114244',
      '43212111',
      '32130133',
      '00432430',
      '11403213',
      '41332000',
      '11304021',
      '03402030',
      '01202120',
      '33130033',
      '20400211',
      '22331100',
      '12431130',
      '02213401',
      '02310131',
      '21341131',
      '44232211',
      '44441303',
      NULL,
      '33122114',
      '31343331',
      '32023002',
      '23320304',
      '13100400',
      '44240113',
      NULL,
      '014',
      '40',
      NULL,
      NULL,
      '1132414',
      0,
      1.164843,
      1,
      NULL,
      '343321',
      4.032759,
      ' 9- 8-1982',
      ' 5-21-2001',
      76,
      NULL,
      20,
      25,
      9,
      7.299791,
      20,
      5.142669,
      33.824885,
      19,
      33,
      13,
      31,
      9,
      21.868417,
      1.679846,
      14.890053,
      6,
      69.511577,
      18,
      20.332488,
      8,
      97.959017,
      8,
      0.981754,
      91.074954,
      NULL,
      84,
      195.177490,
      173,
      31.169861,
      ' 5-26-1991',
      41,
      65.216542,
      NULL,
      29.610042,
      130,
      196.327013,
      ' 5-10-1989',
      1.168084,
      1.300918,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.518349,
      0.423201,
      1.699160,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9- 5-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-22-1998',
      54.555370,
      81.566724,
      NULL,
      60,
      NULL,
      NULL,
      26.097366,
      93.360525,
      NULL,
      71,
      NULL,
      56,
      ' 3-21-1983',
      10,
      17,
      NULL,
      45.778132,
      89.371981,
      NULL,
      13.734140,
      '11-22-1994',
      3,
      4,
      ' 8- 7-1993',
      10.143844,
      11.590284,
      NULL,
      10,
      11.183481,
      2.796721,
      0.026047,
      21,
      1,
      115.949468,
      1.219258,
      NULL,
      11,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8- 0-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10.824262,
      NULL,
      37,
      '11- 1-1992',
      0,
      84,
      ' 7- 6-1994',
      NULL,
      17.377835,
      NULL,
      31.846185,
      ' 0-18-1977',
      45,
      0.410976,
      43.418277,
      '11-14-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      65,
      12.676253,
      NULL,
      NULL,
      NULL,
      22.052220,
      7,
      10,
      1.730303,
      3,
      NULL,
      1,
      1,
      39.451743,
      NULL,
      1,
      20.239347,
      1.734546,
      NULL,
      118,
      1.655828,
      0.574423,
      145,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      22,
      NULL,
      NULL,
      3.983755,
      NULL,
      5.333681,
      0.767034,
      2,
      8,
      32.212357,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      22,
      NULL,
      NULL,
      5.343047,
      NULL,
      NULL,
      3.622837,
      1.198419,
      NULL,
      0.492841,
      1.932858,
      1.553913,
      1,
      NULL,
      ' 9-18-1990',
      ' 8-11-1976',
      ' 8-13-1988',
      ' 4- 5-1984',
      ' 9-14-1987',
      ' 4-13-1999',
      NULL,
      NULL);
commit;
end;
/


