set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9122060';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '13340044',
      '03020110',
      '41044301',
      '13404320',
      '32313143',
      '13322201',
      NULL,
      '20201103',
      '43004222',
      '32133433',
      '23123243',
      '34042244',
      NULL,
      NULL,
      '22142312',
      '03200423',
      '40122402',
      '24332221',
      '03403432',
      '02133324',
      '22142144',
      '34320113',
      '02402204',
      '02232112',
      '00224411',
      '03123041',
      '31124113',
      '03102414',
      '33300244',
      '21301440',
      '23013301',
      '13414430',
      '00323114',
      '32123424',
      '32032231',
      '21002414',
      '21414320',
      '32234131',
      '13303403',
      '03100321',
      NULL,
      '13203440',
      '23441001',
      '12434433',
      '223',
      '03',
      NULL,
      NULL,
      '4043401',
      1,
      1.578092,
      2,
      NULL,
      '114114',
      NULL,
      ' 6-14-1997',
      ' 6- 8-1982',
      62.325740,
      NULL,
      40,
      21,
      21.982120,
      NULL,
      NULL,
      20.445508,
      17,
      7.646126,
      64,
      6,
      10,
      27,
      27.836213,
      NULL,
      8.764105,
      6,
      72.219881,
      NULL,
      53.420141,
      NULL,
      56,
      1,
      1,
      NULL,
      93,
      89,
      34,
      56,
      34.575308,
      NULL,
      45.687446,
      74,
      1.870488,
      17,
      53,
      NULL,
      ' 2-12-1991',
      0,
      0.365691,
      3,
      1.315066,
      1,
      0,
      1,
      1,
      1,
      0,
      0.478466,
      0,
      0,
      0.081707,
      0.259495,
      NULL,
      2,
      0,
      1.624923,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-21-1988',
      41,
      17.866082,
      9,
      1,
      NULL,
      7,
      ' 3-25-1996',
      0,
      1,
      109,
      3,
      1,
      177,
      3,
      1,
      63.702489,
      1,
      3.235547,
      30,
      ' 7-29-1997',
      3.467061,
      130,
      NULL,
      107.032834,
      88,
      104,
      NULL,
      6.429605,
      5.108727,
      75,
      68.359785,
      85.689562,
      '10-25-2000',
      NULL,
      21.764953,
      22.763125,
      3,
      13,
      71,
      8,
      ' 2-20-1981',
      7,
      NULL,
      ' 8- 0-1975',
      0,
      1.139753,
      31,
      10.221813,
      31,
      9,
      NULL,
      7.036864,
      0,
      82.747374,
      0,
      1.587412,
      NULL,
      NULL,
      0,
      1,
      1.088253,
      0,
      ' 6-22-1996',
      NULL,
      5,
      2,
      ' 8-28-1984',
      NULL,
      2,
      ' 1- 5-2003',
      49,
      NULL,
      ' 3-16-1985',
      9.671724,
      ' 8- 0-1976',
      28.696014,
      ' 6-26-1981',
      NULL,
      14,
      ' 9-24-1989',
      94.055151,
      38,
      '10-17-1977',
      2.900702,
      7.732446,
      '11-22-1985',
      0,
      NULL,
      ' 4- 0-1987',
      NULL,
      0,
      8,
      ' 6- 8-1976',
      51,
      33,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10);
commit;
end;
/


