set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '3372312';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      NULL,
      '2',
      NULL,
      '3',
      NULL,
      '2',
      '1',
      '0',
      '0',
      '2',
      '4',
      '2',
      '0',
      '4',
      NULL,
      NULL,
      '4',
      '0',
      '1',
      NULL,
      '4',
      '3',
      '2',
      '',
      '4',
      '',
      '2',
      '1',
      '2',
      NULL,
      '2',
      '',
      NULL,
      '1',
      '3',
      NULL,
      '3',
      '0',
      '1',
      '2',
      NULL,
      NULL,
      '3',
      '4',
      '411',
      '04112314',
      NULL,
      55,
      '3014321',
      1.341077,
      1.632568,
      0,
      NULL,
      NULL,
      1.169323,
      NULL,
      NULL,
      105,
      53.832686,
      10.592499,
      13.615063,
      4.276640,
      14.798979,
      24,
      10,
      NULL,
      3,
      NULL,
      NULL,
      16.076734,
      NULL,
      NULL,
      3,
      24,
      18.821107,
      73.651777,
      5.108388,
      45.985502,
      5.585347,
      5.612636,
      23.109723,
      1,
      62.615993,
      155.239915,
      6,
      136.096196,
      171.049219,
      105,
      ' 9-14-1987',
      40,
      7.504872,
      6,
      25,
      107,
      NULL,
      ' 9-18-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      58,
      5.441330,
      11,
      3,
      6,
      3,
      ' 0-29-1974',
      0,
      NULL,
      91.746543,
      0.602254,
      5,
      NULL,
      NULL,
      1,
      15.821892,
      NULL,
      NULL,
      NULL,
      NULL,
      43.683279,
      15,
      9,
      72.072390,
      14,
      33,
      69,
      45.281186,
      9.876538,
      21,
      43,
      29,
      '11- 0-1991',
      NULL,
      15.549789,
      17,
      53.636615,
      5,
      140,
      3.915012,
      ' 3-23-1986',
      25,
      4.824611,
      ' 7-20-1995',
      2,
      12.376274,
      NULL,
      17,
      23.320500,
      7.917202,
      0,
      16.072740,
      1,
      107,
      NULL,
      NULL,
      10.802304,
      12,
      2.896190,
      NULL,
      1.117869,
      1,
      ' 9-27-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      133.294332,
      5.665696,
      ' 7- 4-1988',
      NULL,
      NULL,
      NULL,
      43,
      ' 9-10-1990',
      11.006769,
      ' 8-25-1987',
      NULL,
      NULL,
      ' 2-17-1989',
      67,
      53,
      '10- 0-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      19.973023,
      ' 1-18-1976',
      3,
      12,
      34.897080,
      ' 3- 6-1979',
      1,
      54.192125,
      NULL,
      9.207113,
      25,
      12,
      3.992664,
      ' 1-20-1984',
      NULL,
      1,
      92.101301,
      ' 8-28-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


