set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '3372312';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '0',
      '3',
      '2',
      NULL,
      '4',
      '3',
      '3',
      NULL,
      '0',
      '2',
      '0',
      '4',
      '1',
      '2',
      '3',
      '4',
      '3',
      NULL,
      '3',
      '1',
      '3',
      '3',
      NULL,
      '',
      '0',
      '',
      '2',
      '1',
      '1',
      '2',
      '4',
      '',
      '',
      '3',
      '0',
      '3',
      '0',
      NULL,
      '2',
      '2',
      '2',
      '2',
      '0',
      '2',
      '311',
      '13442413',
      NULL,
      50,
      '4023103',
      1.269525,
      NULL,
      1,
      NULL,
      '443444',
      2,
      NULL,
      ' 0-25-1978',
      NULL,
      NULL,
      35,
      13,
      4.539281,
      13,
      13.454388,
      13,
      NULL,
      NULL,
      25,
      12,
      7.868048,
      19,
      5.710305,
      11,
      35.969359,
      11,
      32,
      19.689665,
      72.283891,
      10,
      92.110248,
      16.347308,
      1.460805,
      109.367352,
      79,
      57,
      206.131123,
      129.291704,
      NULL,
      ' 0-23-1983',
      72,
      NULL,
      24,
      16.014342,
      123.479856,
      242.456254,
      ' 5- 4-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      74,
      12.405873,
      1.388137,
      0.970530,
      2.827889,
      10.503705,
      ' 8-29-1994',
      NULL,
      1.923173,
      124.441582,
      0,
      2.314714,
      160.789347,
      1.655551,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-14-1991',
      100.674872,
      50,
      37.631363,
      73,
      NULL,
      NULL,
      95.805561,
      85.013481,
      98.694955,
      1.507533,
      21.841050,
      NULL,
      ' 9- 7-1976',
      4,
      7,
      0.558934,
      11.548107,
      47.529351,
      51.831275,
      7,
      ' 6- 2-1977',
      10,
      7.878019,
      ' 2-14-1990',
      4.821141,
      NULL,
      9.274520,
      7,
      17,
      5.184889,
      0,
      4.964027,
      0,
      NULL,
      0.464752,
      1.025606,
      2.306118,
      26,
      0,
      0.856803,
      0,
      1.501637,
      ' 3- 3-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      153.732442,
      NULL,
      ' 1- 8-1999',
      NULL,
      NULL,
      NULL,
      31,
      ' 9- 9-2002',
      33,
      ' 1-16-1980',
      NULL,
      13,
      '10-23-1992',
      NULL,
      127.579645,
      ' 5-13-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      21.347338,
      ' 9-25-1978',
      40,
      11.636136,
      30.600608,
      ' 6-23-1976',
      0,
      5.205338,
      NULL,
      1.927430,
      19.828145,
      NULL,
      27,
      ' 5-28-1982',
      40.161116,
      0,
      37.890094,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


