set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9506730';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '22323414',
      '22420340',
      '31400301',
      '44242242',
      '04103044',
      NULL,
      '10213010',
      '34410122',
      '00120113',
      '03430001',
      '04044431',
      '01124223',
      '20313001',
      '24314024',
      '21410344',
      '00314210',
      '13044344',
      '24220104',
      '30323214',
      '22130232',
      '02422202',
      '02222233',
      '13120201',
      '31132330',
      '11444431',
      NULL,
      NULL,
      '10103202',
      '01423121',
      '10422433',
      '24143303',
      '31011420',
      '01222031',
      NULL,
      '20104202',
      '21042141',
      NULL,
      '12003343',
      '23100400',
      NULL,
      '04042420',
      NULL,
      NULL,
      '42311033',
      '203',
      NULL,
      NULL,
      NULL,
      '2404003',
      2.273662,
      1,
      3,
      NULL,
      '242400',
      0.509658,
      ' 7-25-1981',
      ' 3- 4-1985',
      NULL,
      NULL,
      11.302333,
      5,
      16,
      3.525567,
      NULL,
      7.777658,
      21,
      16,
      19.077913,
      12,
      35,
      25,
      NULL,
      8,
      NULL,
      8,
      NULL,
      NULL,
      37.859291,
      8,
      82,
      4.960014,
      0,
      36.783762,
      NULL,
      65,
      101,
      93,
      101,
      NULL,
      NULL,
      43,
      NULL,
      23,
      NULL,
      130,
      ' 2- 2-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      27,
      35.688646,
      11,
      25.288958,
      NULL,
      ' 0-12-1987',
      1,
      0.471175,
      159,
      NULL,
      NULL,
      115,
      3,
      3,
      81.410983,
      NULL,
      NULL,
      NULL,
      '11-12-1989',
      NULL,
      NULL,
      50.868512,
      NULL,
      94,
      34.001022,
      89,
      NULL,
      NULL,
      7.791768,
      29.416991,
      24,
      ' 3-29-1986',
      NULL,
      23,
      1.054819,
      12.564369,
      91,
      5.083197,
      NULL,
      ' 9-26-1992',
      NULL,
      0,
      '10-21-1996',
      7,
      3,
      NULL,
      26.740654,
      28.808183,
      NULL,
      2,
      19.897012,
      0,
      54,
      6,
      NULL,
      11,
      12.314581,
      0.842811,
      0.941840,
      1.142397,
      5.492925,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      26,
      14,
      ' 8- 6-1982',
      NULL,
      NULL,
      NULL,
      47.473389,
      '10- 0-1998',
      NULL,
      ' 5-26-1979',
      2,
      1.862598,
      ' 9- 8-1996',
      NULL,
      NULL,
      NULL,
      9,
      6.103161,
      ' 1-17-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      16.716471,
      ' 4-10-2003',
      65,
      NULL,
      NULL,
      ' 1- 8-2000',
      0.635791,
      118,
      NULL,
      17,
      NULL,
      14.044160,
      NULL,
      ' 7-22-1987',
      69.147800,
      0,
      159,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


